/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Channel;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.Type;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateStepListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.information.MatchInformation;
import org.boxed_economy.ipd.presentation.IPDBattlePanel;

public class IPDBattleViewer
extends AbstractInternalFrameComponent
implements ModelContainerListener,
UpdateChannelListener,
UpdateStepListener {
    private IPDBattlePanel panel;

    public IPDBattleViewer() {
        this.setTitle("IPD Battle Viewer");
        this.setSize(new Dimension(300, 120));
        this.panel = new IPDBattlePanel();
        this.panel.setPreferredSize(new Dimension(250, 90));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.panel);
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    public void initialize() {
    }

    public void terminate() {
    }

    public void prepareWorldClose(ModelContainerEvent e) {
    }

    public void prepareWorldOpen(ModelContainerEvent e) {
    }

    public void worldClosed(ModelContainerEvent e) {
        this.removeUpdateChannelListener(this);
        this.removeUpdateStepListener(this);
    }

    public void worldOpened(ModelContainerEvent e) {
        this.addUpdateChannelListener(this);
        this.addUpdateStepListener(this);
        this.panel.setPlayers(null, null);
        this.repaint();
    }

    public void goodsReceive(UpdateChannelEvent e) {
    }

    public void goodsSent(UpdateChannelEvent e) {
        Channel c = (Channel)e.getSource();
        if (c.getBehaviorA().getType().equals((Type)IPDModel.BEHAVIORTYPE_ManageContestBehavior) && c.getBehaviorB().getType().equals((Type)IPDModel.BEHAVIORTYPE_ConductMatchBehavior)) {
            MatchInformation match = (MatchInformation)c.getBehaviorA().getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_CurrentMatchInformation);
            Agent player = match.getEntryPair().getFirstPlayer();
            Agent opponent = match.getEntryPair().getLastPlayer();
            this.panel.setPlayers(player, opponent);
            this.repaint();
            System.out.println(String.valueOf(this.panel.getPlayerName(player)) + " : " + this.panel.getPlayerName(opponent));
        }
    }

    public void prepareStepStart(UpdateClockEvent e) {
        this.panel.setIsRock(false);
    }

    public void stepCompleted(UpdateClockEvent e) {
        this.panel.setIsRock(true);
    }
}

