/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.presentation;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.ipd.presentation.IPDScoreViewer;
import org.boxed_economy.ipd.presentation.ObjectWithScore;

public class IPDPlayerTotalScoreTableModel
extends AbstractTableModel {
    private IPDScoreViewer viewer;

    public IPDPlayerTotalScoreTableModel(IPDScoreViewer viewer) {
        this.viewer = viewer;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Player";
            }
            case 1: {
                return "Strategy";
            }
            case 2: {
                return "Total Score";
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.viewer.getPlayer_ScoreMap().entrySet().size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        List playerWithTotalScores = this.viewer.setSortedList(this.viewer.getPlayer_ScoreMap());
        ObjectWithScore o = (ObjectWithScore)playerWithTotalScores.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.viewer.getPlayerName((Agent)o.getKey());
            }
            case 1: {
                return this.viewer.getStrategyName((BehaviorType)this.viewer.getPlayer_StrategyBehaviorTypeMap().get(o.getKey()));
            }
            case 2: {
                return new Double(o.getValue());
            }
        }
        return null;
    }

    public void update() {
        this.fireTableDataChanged();
    }
}

