/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateStepListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.components.stepclock.StepClock;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.behavior.ManageContestBehavior;
import org.boxed_economy.ipd.model.information.MatchInformation;
import org.boxed_economy.ipd.presentation.IPDPlayerTotalScoreTableModel;
import org.boxed_economy.ipd.presentation.IPDStrategyAverageScoreTableModel;
import org.boxed_economy.ipd.presentation.ObjectWithScore;

public class IPDScoreViewer
extends AbstractInternalFrameComponent
implements ModelContainerListener,
UpdateChannelListener,
UpdateStepListener {
    private HashMap player_scoreMap = new HashMap();
    private HashMap previousPlayer_scoreMap;
    private HashMap player_strategyBehaviorTypeMap = new HashMap();
    private HashMap previousPlayer_strategyBehaviorTypeMap;
    private JTabbedPane tabbedPane;
    private JTable playerTotalScoreTable;
    private IPDPlayerTotalScoreTableModel playerTotalScoreModel;
    private JTable strategyAverageScoreTable;
    private IPDStrategyAverageScoreTableModel strategyAverageScoreTableModel;
    private JLabel stepText;
    private long startStep = 0L;
    private boolean canReadData = false;

    public IPDScoreViewer() {
        this.previousPlayer_scoreMap = new HashMap();
        this.previousPlayer_strategyBehaviorTypeMap = new HashMap();
        this.stepText = new JLabel("Step : ");
        this.setTitle("IPD Score Viewer");
        this.setPreferredSize(new Dimension(600, 450));
        JPanel stepPanel = new JPanel(new GridLayout(1, 1));
        stepPanel.add(this.stepText);
        this.getContentPane().add("North", stepPanel);
        this.playerTotalScoreTable = new JTable();
        this.playerTotalScoreTable.createDefaultColumnsFromModel();
        this.playerTotalScoreModel = new IPDPlayerTotalScoreTableModel(this);
        this.playerTotalScoreTable.setModel(this.playerTotalScoreModel);
        JScrollPane scolledPlayerTotalScorePane = new JScrollPane();
        scolledPlayerTotalScorePane.getViewport().add(this.playerTotalScoreTable);
        this.strategyAverageScoreTable = new JTable();
        this.strategyAverageScoreTable.createDefaultColumnsFromModel();
        this.strategyAverageScoreTableModel = new IPDStrategyAverageScoreTableModel(this);
        this.strategyAverageScoreTable.setModel(this.strategyAverageScoreTableModel);
        JScrollPane scolledStrategyAverageScorePane = new JScrollPane();
        scolledStrategyAverageScorePane.getViewport().add(this.strategyAverageScoreTable);
        this.tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tabbedPane.add("Player Total Score", scolledPlayerTotalScorePane);
        this.tabbedPane.add("Strategy Average Score", scolledStrategyAverageScorePane);
    }

    public void worldOpened(ModelContainerEvent arg0) {
        this.addUpdateChannelListener(this);
        this.addUpdateStepListener(this);
        this.player_scoreMap.clear();
        this.player_strategyBehaviorTypeMap.clear();
        this.previousPlayer_scoreMap.clear();
        this.previousPlayer_strategyBehaviorTypeMap.clear();
        this.stepText.setText("Step : ");
        this.startStep = 0L;
        this.canReadData = false;
        this.playerTotalScoreModel.update();
        this.strategyAverageScoreTableModel.update();
        this.repaint();
    }

    public void worldClosed(ModelContainerEvent arg0) {
        this.removeUpdateChannelListener(this);
        this.removeUpdateStepListener(this);
    }

    public void goodsReceive(UpdateChannelEvent arg0) {
        Information informationOnChannel = arg0.getGoods().getAttachment();
        Behavior targetBehavior = arg0.getTargetBehavior();
        if (informationOnChannel instanceof MatchInformation && targetBehavior instanceof ManageContestBehavior) {
            MatchInformation match = (MatchInformation)informationOnChannel;
            Agent firstPlayer = match.getEntryPair().getFirstPlayer();
            Agent lastPlayer = match.getEntryPair().getLastPlayer();
            int scoreOfFirstPlayer = match.getResultScore(firstPlayer);
            int scoreOfLastPlayer = match.getResultScore(lastPlayer);
            this.addScoreByPlayer(firstPlayer, scoreOfFirstPlayer);
            this.addScoreByPlayer(lastPlayer, scoreOfLastPlayer);
        }
    }

    public void stepCompleted(UpdateClockEvent e) {
        this.canReadData = true;
        this.playerTotalScoreModel.update();
        this.strategyAverageScoreTableModel.update();
        this.repaint();
        this.stepEnd(e);
    }

    public void prepareStepStart(UpdateClockEvent e) {
        this.previousPlayer_scoreMap = this.player_scoreMap;
        this.previousPlayer_strategyBehaviorTypeMap = this.player_strategyBehaviorTypeMap;
        this.player_scoreMap = new HashMap();
        this.player_strategyBehaviorTypeMap = new HashMap();
        this.stepBegin(e);
        this.canReadData = false;
    }

    private void addScoreByPlayer(Agent player, double earnedScore) {
        if (this.player_scoreMap.containsKey(player)) {
            double oldScore = (Double)this.player_scoreMap.get(player);
            double newScore = oldScore + earnedScore;
            this.player_scoreMap.put(player, new Double(newScore));
        } else {
            this.player_scoreMap.put(player, new Double(earnedScore));
            Behavior strategyBehavior = (Behavior)((List)player.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0);
            BehaviorType strategyType = strategyBehavior.getType();
            this.player_strategyBehaviorTypeMap.put(player, strategyType);
        }
    }

    public List setSortedList(Map map) {
        ArrayList<ObjectWithScore> keyAndValues = new ArrayList<ObjectWithScore>();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            double value = (Double)map.get(key);
            keyAndValues.add(new ObjectWithScore(key, value));
        }
        Collections.sort(keyAndValues);
        return keyAndValues;
    }

    private void stepBegin(UpdateClockEvent e) {
        StepClock clock = (StepClock)e.getSource();
        if (this.startStep == 0L) {
            this.startStep = clock.getStep();
            this.stepText.setText("Step " + Long.toString(clock.getStep() - this.startStep + 1L) + " is running now...");
        } else {
            this.stepText.setText("Step " + Long.toString(clock.getStep() - this.startStep + 2L) + " is running now...");
        }
    }

    private void stepEnd(UpdateClockEvent e) {
        StepClock clock = (StepClock)e.getSource();
        if (this.startStep == 0L) {
            this.startStep = clock.getStep();
        }
        this.stepText.setText("Step " + Long.toString(clock.getStep() - this.startStep + 1L) + " is completed.");
    }

    public String getPlayerName(Agent player) {
        return player.getInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation).toString();
    }

    public String getStrategyName(BehaviorType strategy) {
        StringBuffer sb = new StringBuffer(strategy.getName());
        sb.delete(0, sb.lastIndexOf(".") + 1).toString();
        sb.delete(sb.indexOf("StrategyBehavior"), sb.length());
        return sb.toString();
    }

    public HashMap getPlayer_ScoreMap() {
        if (this.canReadData) {
            return this.player_scoreMap;
        }
        return this.previousPlayer_scoreMap;
    }

    public HashMap getPlayer_StrategyBehaviorTypeMap() {
        if (this.canReadData) {
            return this.player_strategyBehaviorTypeMap;
        }
        return this.previousPlayer_strategyBehaviorTypeMap;
    }

    public void initialize() {
    }

    public void terminate() {
    }

    public void prepareWorldClose(ModelContainerEvent arg0) {
    }

    public void prepareWorldOpen(ModelContainerEvent arg0) {
    }

    public void goodsSent(UpdateChannelEvent arg0) {
    }
}

