/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.ipd.presentation.IPDScoreViewer;
import org.boxed_economy.ipd.presentation.ObjectWithScore;

public class IPDStrategyAverageScoreTableModel
extends AbstractTableModel {
    private IPDScoreViewer viewer;

    public IPDStrategyAverageScoreTableModel(IPDScoreViewer viewer) {
        this.viewer = viewer;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Strategy";
            }
            case 1: {
                return "Average Score";
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.createStrategy_ScoreListMap().entrySet().size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Map strategyBehaviorType_scoreListMap = this.createStrategy_ScoreListMap();
        Map strategyBehaviorType_averageScoreMap = this.createStrategy_AverageScoreMap(strategyBehaviorType_scoreListMap);
        List strategyWithAverageScores = this.viewer.setSortedList(strategyBehaviorType_averageScoreMap);
        ObjectWithScore o = (ObjectWithScore)strategyWithAverageScores.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.viewer.getStrategyName((BehaviorType)o.getKey());
            }
            case 1: {
                return new Double(o.getValue());
            }
        }
        return null;
    }

    public void update() {
        this.fireTableDataChanged();
    }

    private Map createStrategy_ScoreListMap() {
        HashMap strategyBehaviorType_scoreListMap = new HashMap();
        Iterator i = this.viewer.getPlayer_ScoreMap().keySet().iterator();
        while (i.hasNext()) {
            List<Double> scores;
            Agent player = (Agent)i.next();
            BehaviorType strategyBehaviorType = (BehaviorType)this.viewer.getPlayer_StrategyBehaviorTypeMap().get(player);
            if (strategyBehaviorType_scoreListMap.containsKey(strategyBehaviorType)) {
                scores = (List)strategyBehaviorType_scoreListMap.get(strategyBehaviorType);
                scores.add(new Double((Double)this.viewer.getPlayer_ScoreMap().get(player)));
                continue;
            }
            scores = new ArrayList();
            scores.add(new Double((Double)this.viewer.getPlayer_ScoreMap().get(player)));
            strategyBehaviorType_scoreListMap.put(strategyBehaviorType, scores);
        }
        return strategyBehaviorType_scoreListMap;
    }

    private Map createStrategy_AverageScoreMap(Map strategyBehaviorType_scoreListMap) {
        HashMap<BehaviorType, Double> strategyBehaviorType_averageScoreMap = new HashMap<BehaviorType, Double>();
        Iterator i = strategyBehaviorType_scoreListMap.keySet().iterator();
        while (i.hasNext()) {
            BehaviorType strategyBehaviorType = (BehaviorType)i.next();
            List scores = (List)strategyBehaviorType_scoreListMap.get(strategyBehaviorType);
            double totalScore = 0.0;
            int size = scores.size();
            while (!scores.isEmpty()) {
                double score = (Double)scores.remove(0);
                totalScore += score;
            }
            double averageScore = totalScore / (double)size;
            strategyBehaviorType_averageScoreMap.put(strategyBehaviorType, new Double(averageScore));
        }
        return strategyBehaviorType_averageScoreMap;
    }
}

