/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.presentation.IPDStrategyEvolutionViewer;
import org.boxed_economy.ipd.presentation.ImageProvider;

public class IPDStrategyEvolutionPanel
extends JPanel {
    private IPDStrategyEvolutionViewer viewer;
    private ImageIcon playerIcon;
    private ImageIcon arrowIcon;
    private ImageIcon roseIcon;
    private static final int heightBetweenPlayer = 120;
    private static final int widthBetweenStrategy = 120;

    public IPDStrategyEvolutionPanel(IPDStrategyEvolutionViewer viewer) {
        this.viewer = viewer;
        Image playerImage = ImageProvider.getInstance().getImage("org/boxed_economy/ipd/presentation/player.gif");
        this.playerIcon = new ImageIcon(playerImage);
        Image arrowImage = ImageProvider.getInstance().getImage("org/boxed_economy/ipd/presentation/arrow.gif");
        this.arrowIcon = new ImageIcon(arrowImage);
        Image roseImage = ImageProvider.getInstance().getImage("org/boxed_economy/ipd/presentation/rose.gif");
        this.roseIcon = new ImageIcon(roseImage);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.initializePanel(g);
        this.paintCurrentSituation(g);
    }

    private void initializePanel(Graphics g) {
        this.setBackground(Color.white);
        g.setFont(new Font("Verdana", 0, 10));
    }

    private void paintCurrentSituation(Graphics g) {
        HashMap player_selectedStrategyListMap = this.viewer.getPlayer_selectedStrategyListMap();
        HashMap player_strategyCandidateListMap = this.viewer.getPlayer_strategyCandidateListMap();
        int playerIndex = 0;
        int changeSize = 0;
        Iterator i = player_selectedStrategyListMap.keySet().iterator();
        while (i.hasNext()) {
            Agent player = (Agent)i.next();
            this.drawPlayerBeginningSituation(g, player_selectedStrategyListMap, playerIndex, player);
            List candidatesList = (List)player_strategyCandidateListMap.get(player);
            if (candidatesList != null) {
                changeSize = candidatesList.size();
                int changeIndex = 0;
                while (changeIndex < changeSize) {
                    this.drawArrowAndStrategyCandidates(g, player_selectedStrategyListMap, player_strategyCandidateListMap, playerIndex, changeIndex, player);
                    ++changeIndex;
                }
            }
            ++playerIndex;
        }
        int panelWidth = changeSize * 120 + 100;
        int panelHeight = playerIndex * 120 + 30;
        this.setPreferredSize(new Dimension(panelWidth, panelHeight));
    }

    private void drawPlayerBeginningSituation(Graphics g, HashMap player_selectedStrategyListMap, int playerIndex, Agent player) {
        List strategyList = (List)player_selectedStrategyListMap.get(player);
        BehaviorType strategyType = (BehaviorType)strategyList.get(0);
        this.playerIcon.paintIcon(this, g, 10, 10 + playerIndex * 120);
        g.setColor(Color.BLACK);
        g.drawString(this.getPlayerName(player), 20, 56 + playerIndex * 120);
        this.drawLineWithShadow(g, 45, 17 + playerIndex * 120, 68, 19);
        this.drawStringWithShadow(g, this.getStrategyName(strategyType), 50, 30 + playerIndex * 120);
    }

    private void drawArrowAndStrategyCandidates(Graphics g, HashMap player_selectedStrategyListMap, HashMap player_strategyCandidateListMap, int playerIndex, int changeIndex, Agent player) {
        this.arrowIcon.paintIcon(this, g, 120 + changeIndex * 120, 18 + playerIndex * 120);
        List strategyCandidatesList = (List)player_strategyCandidateListMap.get(player);
        if (strategyCandidatesList != null) {
            List selectedStrategys = (List)player_selectedStrategyListMap.get(player);
            BehaviorType selectedStrategy = (BehaviorType)selectedStrategys.get(changeIndex + 1);
            HashMap strategyCandidates = (HashMap)strategyCandidatesList.get(changeIndex);
            this.drawStringWithShadow(g, this.getStrategyName(selectedStrategy), 170 + changeIndex * 120, 30 + playerIndex * 120);
            if (strategyCandidates.containsKey(selectedStrategy)) {
                strategyCandidates.remove(selectedStrategy);
            }
            g.setColor(Color.DARK_GRAY);
            int candidateIndex = 1;
            Iterator j = strategyCandidates.keySet().iterator();
            while (j.hasNext()) {
                BehaviorType candidateType = (BehaviorType)j.next();
                g.drawString(this.getStrategyName(candidateType), 170 + changeIndex * 120, 30 + playerIndex * 120 + candidateIndex * 10);
                ++candidateIndex;
            }
            this.drawLineWithShadow(g, 164 + changeIndex * 120, 17 + playerIndex * 120, 67, 10 + 10 * candidateIndex);
            this.roseIcon.paintIcon(this, g, 160 + changeIndex * 120, 22 + playerIndex * 120);
        }
    }

    private void drawLineWithShadow(Graphics g, int x, int y, int width, int height) {
        g.setColor(Color.BLACK);
        g.drawRect(x, y, width, height);
        g.setColor(Color.GRAY);
        g.drawLine(x + width + 1, y + 1, x + width + 1, y + height + 1);
        g.drawLine(x + 1, y + height + 1, x + width, y + height + 1);
    }

    private void drawStringWithShadow(Graphics g, String s, int x, int y) {
        g.setColor(Color.LIGHT_GRAY);
        g.drawString(s, x + 2, y);
        g.setColor(Color.GRAY);
        g.drawString(s, x + 1, y);
        g.setColor(Color.BLACK);
        g.drawString(s, x, y);
    }

    public String getPlayerName(Agent player) {
        return player.getInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation).toString();
    }

    public String getStrategyName(BehaviorType strategy) {
        StringBuffer sb = new StringBuffer(strategy.getName());
        sb.delete(0, sb.lastIndexOf(".") + 1).toString();
        sb.delete(sb.indexOf("StrategyBehavior"), sb.length());
        return sb.toString();
    }
}

