/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.Type;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateStepListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.information.ContestInformation;
import org.boxed_economy.ipd.presentation.IPDStrategyEvolutionPanel;

public class IPDStrategyEvolutionViewer
extends AbstractInternalFrameComponent
implements ModelContainerListener,
UpdateStepListener,
UpdateChannelListener {
    private World ipdWorld;
    private HashMap player_selectedStrategyList_Map = new HashMap();
    private HashMap player_strategyCandidateList_Map = new HashMap();
    private IPDStrategyEvolutionPanel panel;
    private ImageIcon playerIcon;

    public IPDStrategyEvolutionViewer() {
        this.setTitle("IPD Strategy Evolution Viewer");
        this.setSize(new Dimension(400, 400));
        this.panel = new IPDStrategyEvolutionPanel(this);
        this.panel.setPreferredSize(new Dimension(1600, 1600));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.panel);
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    public void worldOpened(ModelContainerEvent e) {
        this.addUpdateChannelListener(this);
        this.addUpdateStepListener(this);
        this.player_selectedStrategyList_Map.clear();
        this.player_strategyCandidateList_Map.clear();
        this.ipdWorld = e.getWorld();
        this.recordSelectedStrategyByEachAgent();
        this.repaint();
    }

    public void worldClosed(ModelContainerEvent arg0) {
        this.removeUpdateChannelListener(this);
        this.removeUpdateStepListener(this);
    }

    public void goodsReceive(UpdateChannelEvent e) {
        if (e.getGoods().hasInformation((Information)IPDModel.INFORMATIONTYPE_ContestResultInformation)) {
            Agent player = e.getTargetBehavior().getAgent();
            ContestInformation contestResult = (ContestInformation)e.getGoods().getInformation((Information)IPDModel.INFORMATIONTYPE_ContestResultInformation);
            this.recordStrategyCandidateList(player, contestResult);
        }
    }

    public void stepCompleted(UpdateClockEvent e) {
        this.recordSelectedStrategyByEachAgent();
        this.repaint();
    }

    private void recordSelectedStrategyByEachAgent() {
        Collection players = this.ipdWorld.getAgents(IPDModel.AGENTTYPE_PlayerAgent);
        Iterator i = players.iterator();
        while (i.hasNext()) {
            List<BehaviorType> strategies;
            Agent player = (Agent)i.next();
            BehaviorType strategyType = this.getStrategyType(player);
            if (this.player_selectedStrategyList_Map.containsKey(player)) {
                strategies = (List)this.player_selectedStrategyList_Map.get(player);
                strategies.add(strategyType);
                continue;
            }
            strategies = new ArrayList<BehaviorType>();
            strategies.add(strategyType);
            this.player_selectedStrategyList_Map.put(player, strategies);
        }
    }

    private void recordStrategyCandidateList(Agent player, ContestInformation contestResult) {
        List<HashMap<BehaviorType, BehaviorType>> candidateslists;
        Behavior changeStrategy = (Behavior)((List)player.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_ChangeStrategyBehavior)).get(0);
        BehaviorType changeType = changeStrategy.getType();
        List winners = new ArrayList();
        if (changeType.equals((Type)IPDModel.BEHAVIORTYPE_ChangeStrategyWithHighScorePlayersBehavior)) {
            winners = contestResult.getHighScorePlayers(player).getWinners();
        } else if (changeType.equals((Type)IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior)) {
            winners = contestResult.getStrongerPlayers(player).getWinners();
        }
        HashMap<BehaviorType, BehaviorType> strategyCandidates = new HashMap<BehaviorType, BehaviorType>();
        Iterator j = winners.iterator();
        while (j.hasNext()) {
            Agent winner = (Agent)j.next();
            BehaviorType winnerStrategyType = ((Behavior)((List)winner.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0)).getType();
            strategyCandidates.put(winnerStrategyType, winnerStrategyType);
        }
        if (this.player_strategyCandidateList_Map.containsKey(player)) {
            candidateslists = (List)this.player_strategyCandidateList_Map.get(player);
            candidateslists.add(strategyCandidates);
        } else {
            candidateslists = new ArrayList<HashMap<BehaviorType, BehaviorType>>();
            candidateslists.add(strategyCandidates);
            this.player_strategyCandidateList_Map.put(player, candidateslists);
        }
    }

    private BehaviorType getStrategyType(Agent player) {
        Behavior strategyBehavior = (Behavior)((List)player.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0);
        return strategyBehavior.getType();
    }

    public String toStringWithFairing(String value) {
        StringBuffer sb = new StringBuffer(value);
        return sb.delete(0, value.lastIndexOf(".") + 1).toString();
    }

    public HashMap getPlayer_selectedStrategyListMap() {
        return this.player_selectedStrategyList_Map;
    }

    public HashMap getPlayer_strategyCandidateListMap() {
        return this.player_strategyCandidateList_Map;
    }

    public void initialize() {
    }

    public void terminate() {
    }

    public void prepareWorldOpen(ModelContainerEvent arg0) {
    }

    public void prepareWorldClose(ModelContainerEvent arg0) {
    }

    public void prepareStepStart(UpdateClockEvent arg0) {
    }

    public void goodsSent(UpdateChannelEvent arg0) {
    }
}

