/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.presentation;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.World;

public class TestWorldViewer {
    public void printWorldCondition(World world) {
        if (world.getAllAgents().isEmpty()) {
            System.out.println("No agent : " + world);
        } else {
            System.out.println("AgentList");
            Iterator i = world.getAllAgents().iterator();
            while (i.hasNext()) {
                Agent agent = (Agent)i.next();
                System.out.println("\t|- " + agent.getType().getName() + " (=" + agent + ")");
                this.printHoldingGoodsCondition(agent);
                this.printHoldingInformationCondition(agent);
                this.printHoldingRelationCondition(agent);
            }
        }
    }

    private void printHoldingGoodsCondition(Agent agent) {
        System.out.println("\t|\t|- GoodsManager");
        if (agent.getGoodsTypes().isEmpty()) {
            System.out.println("\t|\t|\t|- (No Goods)");
        } else {
            Iterator i = agent.getGoodsTypes().iterator();
            while (i.hasNext()) {
                GoodsType goodsType = (GoodsType)i.next();
                System.out.println("\t|\t|\t|- " + goodsType.getName() + " [" + agent.getQuantity(goodsType).getValueAsDouble() + "]");
            }
        }
        System.out.println("\t|\t|");
    }

    private void printHoldingInformationCondition(Agent agent) {
        System.out.println("\t|\t|- InformationManager");
        try {
            if (agent.getInformations().values().isEmpty()) {
                System.out.println("\t|\t|\t|- (No Information)");
            } else {
                Iterator i = agent.getInformations().values().iterator();
                while (i.hasNext()) {
                    Information information = (Information)i.next();
                    String informationTypeToString = agent.getWorld().getInformationType(information).getName();
                    Pattern pattern = Pattern.compile(String.valueOf(Class.forName(informationTypeToString).getPackage().getName()) + ".");
                    Matcher matcher = pattern.matcher(informationTypeToString);
                    informationTypeToString = matcher.replaceFirst("");
                    System.out.println("\t|\t|\t|- " + informationTypeToString + " (=" + information + ")");
                }
            }
            System.out.println("\t|\t|");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printHoldingRelationCondition(Agent agent) {
        System.out.println("\t|\t|- RelationManager");
        if (agent.getRelationTypes().isEmpty()) {
            System.out.println("\t|\t|\t|- (No Relation)");
        } else {
            Iterator i = agent.getRelationTypes().iterator();
            while (i.hasNext()) {
                RelationType relationType = (RelationType)i.next();
                System.out.println("\t|\t|\t|- " + relationType.getName());
                Iterator j = agent.getRelations(relationType).iterator();
                while (j.hasNext()) {
                    Relation relation = (Relation)j.next();
                    System.out.println("\t|\t|\t|\t|- >> " + relation.getTarget().getType().getName() + " (=" + relation.getTarget() + ")");
                    System.out.println("\t|\t|\t|");
                }
            }
        }
        System.out.println("\t|");
    }
}

