package org.boxed_economy.ipd.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.informations.IntegerInformation;
import org.boxed_economy.besp.model.fmfw.informations.MessageInformation;
import org.boxed_economy.components.stepclock.StepClock;
import org.boxed_economy.ipd.model.information.ContestInformation;
import org.boxed_economy.ipd.model.information.DecisionHistoryInformation;

import org.boxed_economy.ipd.model.IPDModel;

/**
 * IPDWorld
 */
public class IPDWorld extends World {

	/*************************************
	 * Class variable and main method for running on the besp
	 *************************************/
	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(IPDWorld.class.getName());

	public static void main(String[] args) {
		BESP.main(
			new String[] {
				"-model",
				IPDWorld.class.getName(),
				"-logbyfile",
				"log4j.ipd.properties" });
	}

	/*************************************
	 * Parameters
	 *************************************/
	private int turnNumber = 200;
	private int numberOfALLC = 2;
	private int numberOfALLD = 2;
	private int numberOfRANDOM = 2;
	private int numberOfTFT = 2;
	private int numberOfTF2T = 2;
	private int numberOfJOSS = 2;
	private int numberOfFRIEDMAN = 2;
	private int numberOfPERCD = 2;
	private int numberOfPERCCD = 2;

	//List of agents created from AgentGroup
	private List referees = new ArrayList();
	private List aLLCPlayers = new ArrayList();
	private List aLLDPlayers = new ArrayList();
	private List rANDOMPlayers = new ArrayList();
	private List tFTPlayers = new ArrayList();
	private List tF2TPlayers = new ArrayList();
	private List fRIEDMANPlayers = new ArrayList();
	private List jOSSPlayers = new ArrayList();
	private List pERCDPlayers = new ArrayList();
	private List pERCCDPlayers = new ArrayList();

	/*************************************
	 * Initialize
	 *************************************/

	/**
	 * Initialize World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeWorld()
	 */
	public void initializeWorld() {
		logger.info("Initialize World.");
		super.initializeWorld();

		//set the clock
		this.setClock(new StepClock());
	}

	/**
	 *  Initialize Agents.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeAgents()
	 */
	public void initializeAgents() {
		logger.info(" Initialize Agents.");
		super.initializeAgents();

		this.createAgents();
		this.addRelations();
		this.initializeByHands();
	}

	/**
	 * this method is not overrided for automaticaly.
	 */
	private void initializeByHands() {
		Agent referee = (Agent) this.referees.get(0);

		referee.putInformation(
			IPDModel.INFORMATIONTYPE_MatchPairTableInformation,
			new org
				.boxed_economy
				.ipd
				.model
				.information
				.MatchPairTableInformation(
				this.getAgents(IPDModel.AGENTTYPE_PlayerAgent)));

		Collection allPlayers = this.getAgents(IPDModel.AGENTTYPE_PlayerAgent);
		int count = 0;
		for (Iterator i = allPlayers.iterator(); i.hasNext();) {
			count++;
			Agent player = (Agent) i.next();

			player.putInformation(
				IPDModel.INFORMATIONTYPE_NameInformation,
				new MessageInformation("Player" + count));
		}

		LinkedList list = new LinkedList();
	}

	/**
	 * Create Agents.
	 */
	private void createAgents() {
		logger.info("Create Agents.");

		this.createRefereeAgent();
		this.createALLCPlayerAgents();
		this.createALLDPlayerAgents();
		this.createRANDOMPlayerAgents();
		this.createTFTPlayerAgents();
		this.createTF2TPlayerAgents();
		this.createFRIEDMANPlayerAgents();
		this.createJOSSPlayerAgents();
		this.createPERCDPlayerAgents();
		this.createPERCCDPlayerAgents();
	}

	/**
	 * Add Relations
	 */
	private void addRelations() {
		logger.info("Add Relations");

		this.addSelfRelationRelations();
		this.addPlayerRelationRelations();
		this.addReferee1Relations();
	}

	/*************************************
	 * Subroutines to create agents
	 *************************************/

	/**
	 * Create ALLCPlayer Agents
	 */
	private void createALLCPlayerAgents() {
		logger.info("Create ALLCPlayer Agents");

		for (int i = 0; i < numberOfALLC; i++) {
			this.createALLCPlayerAgent();
		}
	}

	/**
	 * Create ALLDPlayer Agents
	 */
	private void createALLDPlayerAgents() {
		logger.info("Create ALLDPlayer Agents");

		for (int i = 0; i < numberOfALLD; i++) {
			this.createALLDPlayerAgent();
		}
	}

	/**
	 * Create RANDOMPlayer Agents
	 */
	private void createRANDOMPlayerAgents() {
		logger.info("Create RANDOMPlayer Agents");

		for (int i = 0; i < numberOfRANDOM; i++) {
			this.createRANDOMPlayerAgent();
		}
	}

	/**
	 * Create TFTPlayer Agents
	 */
	private void createTFTPlayerAgents() {
		logger.info("Create TFTPlayer Agents");

		for (int i = 0; i < numberOfTFT; i++) {
			this.createTFTPlayerAgent();
		}
	}

	/**
	 * Create TF2TPlayer Agents
	 */
	private void createTF2TPlayerAgents() {
		logger.info("Create TF2TPlayer Agents");

		for (int i = 0; i < numberOfTF2T; i++) {
			this.createTF2TPlayerAgent();
		}
	}

	/**
	 * Create FRIEDMANPlayer Agents
	 */
	private void createFRIEDMANPlayerAgents() {
		logger.info("Create FRIEDMANPlayer Agents");

		for (int i = 0; i < numberOfFRIEDMAN; i++) {
			this.createFRIEDMANPlayerAgent();
		}
	}

	/**
	 * Create JOSSPlayer Agents
	 */
	private void createJOSSPlayerAgents() {
		logger.info("Create JOSSPlayer Agents");

		for (int i = 0; i < numberOfJOSS; i++) {
			this.createJOSSPlayerAgent();
		}
	}

	/**
	 * Create PERCDPlayer Agents
	 */
	private void createPERCDPlayerAgents() {
		logger.info("Create PERCDPlayer Agents");

		for (int i = 0; i < numberOfPERCD; i++) {
			this.createPERCDPlayerAgent();
		}
	}

	/**
	 * Create PERCCDPlayer Agents
	 */
	private void createPERCCDPlayerAgents() {
		logger.info("Create PERCCDPlayer Agents");

		for (int i = 0; i < numberOfPERCCD; i++) {
			this.createPERCCDPlayerAgent();
		}
	}

	/**
	 * Create Referee Agent
	 */
	private void createRefereeAgent() {
		logger.info("Create Referee Agent");

		//create agent
		Agent agentReferee = super.createAgent(IPDModel.AGENTTYPE_RefereeAgent);

		//add behavior(s)
		agentReferee.addBehavior(IPDModel.BEHAVIORTYPE_ConductMatchBehavior);
		agentReferee.addBehavior(IPDModel.BEHAVIORTYPE_ManageContestBehavior);

		//put information
		agentReferee.putInformation(
			IPDModel.INFORMATIONTYPE_ContestCountInformation,
			this.createContestCountInformationForAgentReferee(agentReferee));
		agentReferee.putInformation(
			IPDModel.INFORMATIONTYPE_CurrentContestInformation,
			new ContestInformation());

		referees.add(agentReferee);
	}

	/**
	 * Create ALLCPlayer Agent
	 */
	private void createALLCPlayerAgent() {
		logger.info("Create ALLCPlayer Agent");

		//create agent
		Agent agentALLCPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentALLCPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ALLCStrategyBehavior);
		agentALLCPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
		agentALLCPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
		agentALLCPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);

		//put information
		agentALLCPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());
		agentALLCPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentALLCPlayer(agentALLCPlayer));

		aLLCPlayers.add(agentALLCPlayer);
	}

	/**
	 * Create ALLDPlayer Agent
	 */
	private void createALLDPlayerAgent() {
		logger.info("Create ALLDPlayer Agent");

		//create agent
		Agent agentALLDPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentALLDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ALLDStrategyBehavior);
		agentALLDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
		agentALLDPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
		agentALLDPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);

		//put information
		agentALLDPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());
		agentALLDPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentALLDPlayer(agentALLDPlayer));

		aLLDPlayers.add(agentALLDPlayer);
	}

	/**
	 * Create RANDOMPlayer Agent
	 */
	private void createRANDOMPlayerAgent() {
		logger.info("Create RANDOMPlayer Agent");

		//create agent
		Agent agentRANDOMPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentRANDOMPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_RANDOMStrategyBehavior);
		agentRANDOMPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
		agentRANDOMPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
		agentRANDOMPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);

		//put information
		agentRANDOMPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());
		agentRANDOMPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentRANDOMPlayer(agentRANDOMPlayer));

		rANDOMPlayers.add(agentRANDOMPlayer);
	}

	/**
	 * Create TFTPlayer Agent
	 */
	private void createTFTPlayerAgent() {
		logger.info("Create TFTPlayer Agent");

		//create agent
		Agent agentTFTPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentTFTPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
		agentTFTPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
		agentTFTPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
		agentTFTPlayer.addBehavior(IPDModel.BEHAVIORTYPE_TFTStrategyBehavior);

		//put information
		agentTFTPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentTFTPlayer(agentTFTPlayer));
		agentTFTPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());

		tFTPlayers.add(agentTFTPlayer);
	}

	/**
	 * Create TF2TPlayer Agent
	 */
	private void createTF2TPlayerAgent() {
		logger.info("Create TF2TPlayer Agent");

		//create agent
		Agent agentTF2TPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentTF2TPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
		agentTF2TPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
		agentTF2TPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
		agentTF2TPlayer.addBehavior(IPDModel.BEHAVIORTYPE_TF2TStrategyBehavior);

		//put information
		agentTF2TPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());
		agentTF2TPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentTF2TPlayer(agentTF2TPlayer));

		tF2TPlayers.add(agentTF2TPlayer);
	}

	/**
	 * Create FRIEDMANPlayer Agent
	 */
	private void createFRIEDMANPlayerAgent() {
		logger.info("Create FRIEDMANPlayer Agent");

		//create agent
		Agent agentFRIEDMANPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentFRIEDMANPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_FRIEDMANStrategyBehavior);
		agentFRIEDMANPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
		agentFRIEDMANPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
		agentFRIEDMANPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);

		//put information
		agentFRIEDMANPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentFRIEDMANPlayer(
				agentFRIEDMANPlayer));
		agentFRIEDMANPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());

		fRIEDMANPlayers.add(agentFRIEDMANPlayer);
	}

	/**
	 * Create JOSSPlayer Agent
	 */
	private void createJOSSPlayerAgent() {
		logger.info("Create JOSSPlayer Agent");

		//create agent
		Agent agentJOSSPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentJOSSPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
		agentJOSSPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
		agentJOSSPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
		agentJOSSPlayer.addBehavior(IPDModel.BEHAVIORTYPE_JOSSStrategyBehavior);

		//put information
		agentJOSSPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentJOSSPlayer(agentJOSSPlayer));
		agentJOSSPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());

		jOSSPlayers.add(agentJOSSPlayer);
	}

	/**
	 * Create PERCDPlayer Agent
	 */
	private void createPERCDPlayerAgent() {
		logger.info("Create PERCDPlayer Agent");

		//create agent
		Agent agentPERCDPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentPERCDPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_PERCDStrategyBehavior);
		agentPERCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
		agentPERCDPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
		agentPERCDPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);

		//put information
		agentPERCDPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentPERCDPlayer(agentPERCDPlayer));
		agentPERCDPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());

		pERCDPlayers.add(agentPERCDPlayer);
	}

	/**
	 * Create PERCCDPlayer Agent
	 */
	private void createPERCCDPlayerAgent() {
		logger.info("Create PERCCDPlayer Agent");

		//create agent
		Agent agentPERCCDPlayer =
			super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);

		//add behavior(s)
		agentPERCCDPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_PERCCDStrategyBehavior);
		agentPERCCDPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
		agentPERCCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
		agentPERCCDPlayer.addBehavior(
			IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);

		//put information
		agentPERCCDPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_DecisionHistoryInformation,
			new DecisionHistoryInformation());
		agentPERCCDPlayer.putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			this.createScoreInformationForAgentPERCCDPlayer(agentPERCCDPlayer));

		pERCCDPlayers.add(agentPERCCDPlayer);
	}

	/*************************************
	 * Subroutines to add relations
	 *************************************/

	/**
	 * add SelfRelation relations
	 */
	private void addSelfRelationRelations() {
		logger.info("add SelfRelation relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(pERCCDPlayers);
		sourceAgents.addAll(tFTPlayers);
		sourceAgents.addAll(tF2TPlayers);
		sourceAgents.addAll(jOSSPlayers);
		sourceAgents.addAll(aLLCPlayers);
		sourceAgents.addAll(referees);
		sourceAgents.addAll(rANDOMPlayers);
		sourceAgents.addAll(pERCDPlayers);
		sourceAgents.addAll(aLLDPlayers);
		sourceAgents.addAll(fRIEDMANPlayers);

		//Add Relations
		for (int i = 0; i < sourceAgents.size(); i++) {
			Agent sourceAgent = (Agent) sourceAgents.get(i);

			//add relation from source to target
			sourceAgent.addRelation(
				IPDModel.RELATIONTYPE_SelfRelation,
				sourceAgent);

		}
	}

	/**
	 * add PlayerRelation relations
	 */
	private void addPlayerRelationRelations() {
		logger.info("add PlayerRelation relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(referees);
		List targetAgents = new ArrayList(pERCCDPlayers);
		targetAgents.addAll(tFTPlayers);
		targetAgents.addAll(tF2TPlayers);
		targetAgents.addAll(jOSSPlayers);
		targetAgents.addAll(aLLCPlayers);
		targetAgents.addAll(rANDOMPlayers);
		targetAgents.addAll(pERCDPlayers);
		targetAgents.addAll(aLLDPlayers);
		targetAgents.addAll(fRIEDMANPlayers);

		Agent sourceAgent = (Agent) sourceAgents.get(0);

		for (int i = 0; i < targetAgents.size(); i++) {
			Agent targetAgent = (Agent) targetAgents.get(i);

			if (sourceAgent != targetAgent) {
				//add relation from source to target
				sourceAgent.addRelation(
					IPDModel.RELATIONTYPE_PlayerRelation,
					targetAgent);
			}

		}

	}

	/**
	 * add Referee1 relations
	 */
	private void addReferee1Relations() {
		logger.info("add Referee1 relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(pERCCDPlayers);
		sourceAgents.addAll(tFTPlayers);
		sourceAgents.addAll(tF2TPlayers);
		sourceAgents.addAll(jOSSPlayers);
		sourceAgents.addAll(aLLCPlayers);
		sourceAgents.addAll(rANDOMPlayers);
		sourceAgents.addAll(pERCDPlayers);
		sourceAgents.addAll(aLLDPlayers);
		sourceAgents.addAll(fRIEDMANPlayers);
		List targetAgents = new ArrayList(referees);

		Agent targetAgent = (Agent) targetAgents.get(0);

		//Add Relations
		for (int i = 0; i < sourceAgents.size(); i++) {
			Agent sourceAgent = (Agent) sourceAgents.get(i);

			if (sourceAgent != targetAgent) {
				//add relation from source to target
				sourceAgent.addRelation(
					IPDModel.RELATIONTYPE_RefereeRelation,
					targetAgent);
			}

		}

	}

	/*************************************
	 * Name and Desctription for World
	 *************************************/

	/**
	 * Returns the description of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getDescription()
	 */
	public String getName() {
		return "IPDWorld";
	}

	/**
	 * Returns the name of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getName()
	 */
	public String getDescription() {
		return "JԂl̃W}̃fł";
	}

	/*************************************
	 * Factory method(s) for Information
	 *************************************/

	/**
	 * create ScoreInformationForAgentPERCDPlayer
	 */
	private IntegerInformation createScoreInformationForAgentPERCDPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ScoreInformationForAgentFRIEDMANPlayer
	 */
	private IntegerInformation createScoreInformationForAgentFRIEDMANPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ScoreInformationForAgentTF2TPlayer
	 */
	private IntegerInformation createScoreInformationForAgentTF2TPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ScoreInformationForAgentALLCPlayer
	 */
	private IntegerInformation createScoreInformationForAgentALLCPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ContestCountInformationForAgentReferee
	 */
	private IntegerInformation createContestCountInformationForAgentReferee(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ScoreInformationForAgentPERCCDPlayer
	 */
	private IntegerInformation createScoreInformationForAgentPERCCDPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ScoreInformationForAgentALLDPlayer
	 */
	private IntegerInformation createScoreInformationForAgentALLDPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ScoreInformationForAgentJOSSPlayer
	 */
	private IntegerInformation createScoreInformationForAgentJOSSPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ScoreInformationForAgentTFTPlayer
	 */
	private IntegerInformation createScoreInformationForAgentTFTPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/**
	 * create ScoreInformationForAgentRANDOMPlayer
	 */
	private IntegerInformation createScoreInformationForAgentRANDOMPlayer(Agent agent) {
		return new IntegerInformation(0);
	}

	/*************************************
	 * Utility methods for generating random number
	 *************************************/

	/**
	 * Generate random number by double.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private double generateRandomNumberByDouble(
		String generatorName,
		double max,
		double minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		double result = minimum + randomNumber * (max - minimum);

		return result;
	}

	/**
	 * Generate random number by int.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private int generateRandomNumberByInt(
		String generatorName,
		int max,
		int minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		int result = (int) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * Generate random number by long.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private long generateRandomNumberByLong(
		String generatorName,
		long max,
		long minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		long result = (long) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * generate elected numbers excluded the value at random
	 * 
	 * @param key of random number generator
	 * @param number of elected one
	 * @param max
	 * @param exclude number
	 * @return elected numbers
	 */
	private int[] generateElectedRandomNumbers(
		String generatorName,
		int number,
		int max,
		int excludedNumber) {
		assert(number < max);
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);
		int[] electedNumbers = new int[number];
		Arrays.fill(electedNumbers, -1);

		//generate elected number
		for (int i = 0; i < number; i++) {
			int generatedNumber;
			if (excludedNumber >= 0) {
				generatedNumber = generator.generate(max - 1);
				//exclude the number
				if (generatedNumber >= excludedNumber) {
					generatedNumber++;
				}

			} else {
				generatedNumber = generator.generate(max);
			}
			if (isElectedNumber(electedNumbers, generatedNumber)) {
				i--;
				continue;
			} else {
				electedNumbers[i] = generatedNumber;
			}
		}

		return electedNumbers;
	}

	/**
	 * Returns whether target number is elected or not.
	 * 
	 * @param elected numbers
	 * @param target number
	 * @return whether the number is elected
	 */
	private boolean isElectedNumber(int[] electedNumbers, int target) {
		int[] copy = new int[electedNumbers.length];
		for (int i = 0; i < copy.length; i++) {
			copy[i] = electedNumbers[i];
		};

		Arrays.sort(copy);
		int result = Arrays.binarySearch(copy, target);

		return result >= 0;
	}

	/*************************************
	 * Gettere & Setter for initializable parameter(s)
	 *************************************/

	/**
	 * Returns the initializable parameter turnNumber
	 * 
	 * @return turnNumber
	 */
	public int getTurnNumber() {
		return turnNumber;
	}

	/**
	 * Set the initializable parameter turnNumber
	 * 
	 * @param turnNumber
	 */
	public void setTurnNumber(int turnNumber) {
		this.turnNumber = turnNumber;
	}

	/**
	 * Returns the description for turnNumber
	 * 
	 * @return the description forturnNumber
	 */
	public String getTurnNumberComment() {
		return "1̑ΐł̃Q[";
	}

	/**
	 * Returns the initializable parameter numberOfALLC
	 * 
	 * @return numberOfALLC
	 */
	public int getNumberOfALLC() {
		return numberOfALLC;
	}

	/**
	 * Set the initializable parameter numberOfALLC
	 * 
	 * @param numberOfALLC
	 */
	public void setNumberOfALLC(int numberOfALLC) {
		this.numberOfALLC = numberOfALLC;
	}

	/**
	 * Returns the description for numberOfALLC
	 * 
	 * @return the description fornumberOfALLC
	 */
	public String getNumberOfALLCComment() {
		return "ALLC̐헪vC[̐";
	}

	/**
	 * Returns the initializable parameter numberOfALLD
	 * 
	 * @return numberOfALLD
	 */
	public int getNumberOfALLD() {
		return numberOfALLD;
	}

	/**
	 * Set the initializable parameter numberOfALLD
	 * 
	 * @param numberOfALLD
	 */
	public void setNumberOfALLD(int numberOfALLD) {
		this.numberOfALLD = numberOfALLD;
	}

	/**
	 * Returns the description for numberOfALLD
	 * 
	 * @return the description fornumberOfALLD
	 */
	public String getNumberOfALLDComment() {
		return "ALLD̐헪vC[̐";
	}

	/**
	 * Returns the initializable parameter numberOfRANDOM
	 * 
	 * @return numberOfRANDOM
	 */
	public int getNumberOfRANDOM() {
		return numberOfRANDOM;
	}

	/**
	 * Set the initializable parameter numberOfRANDOM
	 * 
	 * @param numberOfRANDOM
	 */
	public void setNumberOfRANDOM(int numberOfRANDOM) {
		this.numberOfRANDOM = numberOfRANDOM;
	}

	/**
	 * Returns the description for numberOfRANDOM
	 * 
	 * @return the description fornumberOfRANDOM
	 */
	public String getNumberOfRANDOMComment() {
		return "RANDOM̐헪vC[̐";
	}

	/**
	 * Returns the initializable parameter numberOfTFT
	 * 
	 * @return numberOfTFT
	 */
	public int getNumberOfTFT() {
		return numberOfTFT;
	}

	/**
	 * Set the initializable parameter numberOfTFT
	 * 
	 * @param numberOfTFT
	 */
	public void setNumberOfTFT(int numberOfTFT) {
		this.numberOfTFT = numberOfTFT;
	}

	/**
	 * Returns the description for numberOfTFT
	 * 
	 * @return the description fornumberOfTFT
	 */
	public String getNumberOfTFTComment() {
		return "TFT̐헪vC[̐";
	}

	/**
	 * Returns the initializable parameter numberOfTF2T
	 * 
	 * @return numberOfTF2T
	 */
	public int getNumberOfTF2T() {
		return numberOfTF2T;
	}

	/**
	 * Set the initializable parameter numberOfTF2T
	 * 
	 * @param numberOfTF2T
	 */
	public void setNumberOfTF2T(int numberOfTF2T) {
		this.numberOfTF2T = numberOfTF2T;
	}

	/**
	 * Returns the description for numberOfTF2T
	 * 
	 * @return the description fornumberOfTF2T
	 */
	public String getNumberOfTF2TComment() {
		return "TF2T̐헪vC[̐";
	}

	/**
	 * Returns the initializable parameter numberOfJOSS
	 * 
	 * @return numberOfJOSS
	 */
	public int getNumberOfJOSS() {
		return numberOfJOSS;
	}

	/**
	 * Set the initializable parameter numberOfJOSS
	 * 
	 * @param numberOfJOSS
	 */
	public void setNumberOfJOSS(int numberOfJOSS) {
		this.numberOfJOSS = numberOfJOSS;
	}

	/**
	 * Returns the description for numberOfJOSS
	 * 
	 * @return the description fornumberOfJOSS
	 */
	public String getNumberOfJOSSComment() {
		return "JOSS̐헪vC[̐";
	}

	/**
	 * Returns the initializable parameter numberOfFRIEDMAN
	 * 
	 * @return numberOfFRIEDMAN
	 */
	public int getNumberOfFRIEDMAN() {
		return numberOfFRIEDMAN;
	}

	/**
	 * Set the initializable parameter numberOfFRIEDMAN
	 * 
	 * @param numberOfFRIEDMAN
	 */
	public void setNumberOfFRIEDMAN(int numberOfFRIEDMAN) {
		this.numberOfFRIEDMAN = numberOfFRIEDMAN;
	}

	/**
	 * Returns the description for numberOfFRIEDMAN
	 * 
	 * @return the description fornumberOfFRIEDMAN
	 */
	public String getNumberOfFRIEDMANComment() {
		return "FRIEDMAN̐헪vC[̐";
	}

	/**
	 * Returns the initializable parameter numberOfPERCD
	 * 
	 * @return numberOfPERCD
	 */
	public int getNumberOfPERCD() {
		return numberOfPERCD;
	}

	/**
	 * Set the initializable parameter numberOfPERCD
	 * 
	 * @param numberOfPERCD
	 */
	public void setNumberOfPERCD(int numberOfPERCD) {
		this.numberOfPERCD = numberOfPERCD;
	}

	/**
	 * Returns the description for numberOfPERCD
	 * 
	 * @return the description fornumberOfPERCD
	 */
	public String getNumberOfPERCDComment() {
		return "PERCD̐헪vC[̐";
	}

	/**
	 * Returns the initializable parameter numberOfPERCCD
	 * 
	 * @return numberOfPERCCD
	 */
	public int getNumberOfPERCCD() {
		return numberOfPERCCD;
	}

	/**
	 * Set the initializable parameter numberOfPERCCD
	 * 
	 * @param numberOfPERCCD
	 */
	public void setNumberOfPERCCD(int numberOfPERCCD) {
		this.numberOfPERCCD = numberOfPERCCD;
	}

	/**
	 * Returns the description for numberOfPERCCD
	 * 
	 * @return the description fornumberOfPERCCD
	 */
	public String getNumberOfPERCCDComment() {
		return "PERCCD̐헪vC[̐";
	}

}
