package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateAction;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.ipd.model.behavior.template.CooperateAction;
import org.boxed_economy.ipd.model.behavior.template.IsCorD;
import org.boxed_economy.ipd.model.behavior.template.IsStartSignal;

/**
* AbstractALLCStrategyBehavior
*/
public abstract class AbstractALLCStrategyBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTurn =
			factory.createCompositeState("WaitingForTurn");

		//actions
		TemplateAction cooperateAction = new CooperateAction();
		cooperateAction.setBehavior(this);

		//guard-conditions
		TemplateGuardCondition isCorD = new IsCorD();
		isCorD.setBehavior(this);
		TemplateGuardCondition isStartSignal = new IsStartSignal();
		isStartSignal.setBehavior(this);

		//transitions
		Transition transitionWaitingForTurnToWaitingForTurn =
			factory.createTransition();
		Transition transitionWaitingForTurnToWaitingForTurn1 =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForTurn =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitingForTurn);

		//transitions setting
		transitionWaitingForTurnToWaitingForTurn.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn.setGuardCondition(
			isStartSignal);
		transitionWaitingForTurnToWaitingForTurn.addAction(cooperateAction);
		transitionWaitingForTurnToWaitingForTurn1.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn1.setGuardCondition(isCorD);
		transitionWaitingForTurnToWaitingForTurn1.addAction(cooperateAction);

		//connection of transitions
		transitionWaitingForTurnToWaitingForTurn.setSourceState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn.setTargetState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn1.setSourceState(
			waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn1.setTargetState(
			waitingForTurn);
		transitionInitialStateToWaitingForTurn.setSourceState(initialState);
		transitionInitialStateToWaitingForTurn.setTargetState(waitingForTurn);

	}

}
