package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractConductMatchBehavior
*/
public abstract class AbstractConductMatchBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForStartTime =
			factory.createCompositeState("WaitingForStartTime");
		CompositeState readyToTurn =
			factory.createCompositeState("ReadyToTurn");
		CompositeState waitingForFirstReply =
			factory.createCompositeState("WaitingForFirstReply");
		CompositeState waitingForSecondReply =
			factory.createCompositeState("WaitingForSecondReply");

		//actions
		Action askNextDecisionAction = new Action() {
			public void doAction() {
				askNextDecisionAction();
			}
			public String toString() {
				return "askNextDecisionAction";
			}
		};
		Action prepareNextTurnAction = new Action() {
			public void doAction() {
				prepareNextTurnAction();
			}
			public String toString() {
				return "prepareNextTurnAction";
			}
		};
		Action initializeRemainingTurnAction = new Action() {
			public void doAction() {
				initializeRemainingTurnAction();
			}
			public String toString() {
				return "initializeRemainingTurnAction";
			}
		};
		Action askFirstDecisionAction = new Action() {
			public void doAction() {
				askFirstDecisionAction();
			}
			public String toString() {
				return "askFirstDecisionAction";
			}
		};
		Action registerDecisionAction = new Action() {
			public void doAction() {
				registerDecisionAction();
			}
			public String toString() {
				return "registerDecisionAction";
			}
		};
		Action reportMatchResultAction = new Action() {
			public void doAction() {
				reportMatchResultAction();
			}
			public String toString() {
				return "reportMatchResultAction";
			}
		};
		Action reportOpponentDeceisionAction = new Action() {
			public void doAction() {
				reportOpponentDeceisionAction();
			}
			public String toString() {
				return "reportOpponentDeceisionAction";
			}
		};

		//guard-conditions
		GuardCondition isNotFinalTurn = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isNotFinalTurn(e);
			}
		};
		GuardCondition isFinalTurn = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isFinalTurn(e);
			}
		};
		GuardCondition isStartSignal = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isStartSignal(e);
			}
		};

		//transitions
		Transition transitionWaitingForSecondReplyToReadyToTurn =
			factory.createTransition();
		Transition transitionReadyToTurnToWaitingForStartTime =
			factory.createTransition();
		Transition transitionWaitingForStartTimeToWaitingForFirstReply =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForStartTime =
			factory.createTransition();
		Transition transitionWaitingForFirstReplyToWaitingForSecondReply =
			factory.createTransition();
		Transition transitionReadyToTurnToWaitingForFirstReply =
			factory.createTransition();

		//states setting
		waitingForStartTime.addEntryAction(initializeRemainingTurnAction);

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitingForStartTime);
		this.addState(readyToTurn);
		this.addState(waitingForFirstReply);
		this.addState(waitingForSecondReply);

		//transitions setting
		transitionWaitingForSecondReplyToReadyToTurn.setEvent(
			ChannelEvent.class);
		transitionWaitingForSecondReplyToReadyToTurn.addAction(
			registerDecisionAction);
		transitionWaitingForSecondReplyToReadyToTurn.addAction(
			reportOpponentDeceisionAction);
		transitionWaitingForSecondReplyToReadyToTurn.addAction(
			prepareNextTurnAction);
		transitionReadyToTurnToWaitingForStartTime.setGuardCondition(
			isFinalTurn);
		transitionReadyToTurnToWaitingForStartTime.addAction(
			reportMatchResultAction);
		transitionWaitingForStartTimeToWaitingForFirstReply.setEvent(
			ChannelEvent.class);
		transitionWaitingForStartTimeToWaitingForFirstReply.setGuardCondition(
			isStartSignal);
		transitionWaitingForStartTimeToWaitingForFirstReply.addAction(
			askFirstDecisionAction);
		transitionWaitingForFirstReplyToWaitingForSecondReply.setEvent(
			ChannelEvent.class);
		transitionWaitingForFirstReplyToWaitingForSecondReply.addAction(
			registerDecisionAction);
		transitionReadyToTurnToWaitingForFirstReply.setGuardCondition(
			isNotFinalTurn);
		transitionReadyToTurnToWaitingForFirstReply.addAction(
			askNextDecisionAction);

		//connection of transitions
		transitionWaitingForSecondReplyToReadyToTurn.setSourceState(
			waitingForSecondReply);
		transitionWaitingForSecondReplyToReadyToTurn.setTargetState(
			readyToTurn);
		transitionReadyToTurnToWaitingForStartTime.setSourceState(readyToTurn);
		transitionReadyToTurnToWaitingForStartTime.setTargetState(
			waitingForStartTime);
		transitionWaitingForStartTimeToWaitingForFirstReply.setSourceState(
			waitingForStartTime);
		transitionWaitingForStartTimeToWaitingForFirstReply.setTargetState(
			waitingForFirstReply);
		transitionInitialStateToWaitingForStartTime.setSourceState(
			initialState);
		transitionInitialStateToWaitingForStartTime.setTargetState(
			waitingForStartTime);
		transitionWaitingForFirstReplyToWaitingForSecondReply.setSourceState(
			waitingForFirstReply);
		transitionWaitingForFirstReplyToWaitingForSecondReply.setTargetState(
			waitingForSecondReply);
		transitionReadyToTurnToWaitingForFirstReply.setSourceState(readyToTurn);
		transitionReadyToTurnToWaitingForFirstReply.setTargetState(
			waitingForFirstReply);

	}

	/**
	*askNextDecisionAction
	*/
	protected abstract void askNextDecisionAction();
	/**
	*prepareNextTurnAction
	*/
	protected abstract void prepareNextTurnAction();
	/**
	*initializeRemainingTurnAction
	*/
	protected abstract void initializeRemainingTurnAction();
	/**
	*askFirstDecisionAction
	*/
	protected abstract void askFirstDecisionAction();
	/**
	*registerDecisionAction
	*/
	protected abstract void registerDecisionAction();
	/**
	*reportMatchResultAction
	*/
	protected abstract void reportMatchResultAction();
	/**
	*reportOpponentDeceisionAction
	*/
	protected abstract void reportOpponentDeceisionAction();
	/**
	*isNotFinalTurn
	*/
	protected abstract boolean isNotFinalTurn(Event e);
	/**
	*isFinalTurn
	*/
	protected abstract boolean isFinalTurn(Event e);
	/**
	*isStartSignal
	*/
	protected abstract boolean isStartSignal(Event e);
}
