package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateAction;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.ipd.model.behavior.template.CooperateAction;
import org.boxed_economy.ipd.model.behavior.template.IsC;
import org.boxed_economy.ipd.model.behavior.template.IsCorD;
import org.boxed_economy.ipd.model.behavior.template.IsStartSignal;

import org.boxed_economy.ipd.model.behavior.template.IsD;

import org.boxed_economy.ipd.model.behavior.template.DefectAction;

/**
* AbstractFRIEDMANStrategyBehavior
*/
public abstract class AbstractFRIEDMANStrategyBehavior
	extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTurn =
			factory.createCompositeState("WaitingForTurn");
		State initialState1 = factory.createInitialState();
		CompositeState quiet = factory.createCompositeState("Quiet");
		CompositeState angry = factory.createCompositeState("Angry");

		//actions
		TemplateAction cooperateAction = new CooperateAction();
		cooperateAction.setBehavior(this);
		TemplateAction defectAction = new DefectAction();
		defectAction.setBehavior(this);

		//guard-conditions
		TemplateGuardCondition isStartSignal = new IsStartSignal();
		isStartSignal.setBehavior(this);
		TemplateGuardCondition isD = new IsD();
		isD.setBehavior(this);
		TemplateGuardCondition isCorD = new IsCorD();
		isCorD.setBehavior(this);
		TemplateGuardCondition isC = new IsC();
		isC.setBehavior(this);

		//transitions
		Transition transitionWaitingForTurnToWaitingForTurn =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForTurn =
			factory.createTransition();
		Transition transitionQuietToQuiet = factory.createTransition();
		Transition transitionAngryToAngry = factory.createTransition();
		Transition transitionInitialStateToQuiet = factory.createTransition();
		Transition transitionQuietToAngry = factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		waitingForTurn.setInitialState(initialState1);
		waitingForTurn.addState(quiet);
		waitingForTurn.addState(angry);
		this.addState(waitingForTurn);

		//transitions setting
		transitionWaitingForTurnToWaitingForTurn.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn.setGuardCondition(
			isStartSignal);
		transitionWaitingForTurnToWaitingForTurn.addAction(cooperateAction);
		transitionQuietToQuiet.setEvent(ChannelEvent.class);
		transitionQuietToQuiet.setGuardCondition(isC);
		transitionQuietToQuiet.addAction(cooperateAction);
		transitionAngryToAngry.setEvent(ChannelEvent.class);
		transitionAngryToAngry.setGuardCondition(isCorD);
		transitionAngryToAngry.addAction(defectAction);
		transitionQuietToAngry.setEvent(ChannelEvent.class);
		transitionQuietToAngry.setGuardCondition(isD);
		transitionQuietToAngry.addAction(defectAction);

		//connection of transitions
		transitionWaitingForTurnToWaitingForTurn.setSourceState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn.setTargetState(waitingForTurn);
		transitionInitialStateToWaitingForTurn.setSourceState(initialState);
		transitionInitialStateToWaitingForTurn.setTargetState(waitingForTurn);
		transitionQuietToQuiet.setSourceState(quiet);
		transitionQuietToQuiet.setTargetState(quiet);
		transitionAngryToAngry.setSourceState(angry);
		transitionAngryToAngry.setTargetState(angry);
		transitionInitialStateToQuiet.setSourceState(initialState1);
		transitionInitialStateToQuiet.setTargetState(quiet);
		transitionQuietToAngry.setSourceState(quiet);
		transitionQuietToAngry.setTargetState(angry);

	}

}
