package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateAction;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.ipd.model.behavior.template.CooperateAction;
import org.boxed_economy.ipd.model.behavior.template.DefectAction;
import org.boxed_economy.ipd.model.behavior.template.IsC;
import org.boxed_economy.ipd.model.behavior.template.IsD;
import org.boxed_economy.ipd.model.behavior.template.IsStartSignal;

/**
* AbstractJOSSStrategyBehavior
*/
public abstract class AbstractJOSSStrategyBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTurn =
			factory.createCompositeState("WaitingForTurn");

		//actions
		Action probabilisticAction = new Action() {
			public void doAction() {
				probabilisticAction();
			}
			public String toString() {
				return "probabilisticAction";
			}
		};
		TemplateAction cooperateAction = new CooperateAction();
		cooperateAction.setBehavior(this);
		TemplateAction defectAction = new DefectAction();
		defectAction.setBehavior(this);

		//guard-conditions
		TemplateGuardCondition isStartSignal = new IsStartSignal();
		isStartSignal.setBehavior(this);
		TemplateGuardCondition isD = new IsD();
		isD.setBehavior(this);
		TemplateGuardCondition isC = new IsC();
		isC.setBehavior(this);

		//transitions
		Transition transitionWaitingForTurnToWaitingForTurn =
			factory.createTransition();
		Transition transitionWaitingForTurnToWaitingForTurn1 =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForTurn =
			factory.createTransition();
		Transition transitionWaitingForTurnToWaitingForTurn2 =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitingForTurn);

		//transitions setting
		transitionWaitingForTurnToWaitingForTurn.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn.setGuardCondition(isD);
		transitionWaitingForTurnToWaitingForTurn.addAction(defectAction);
		transitionWaitingForTurnToWaitingForTurn1.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn1.setGuardCondition(
			isStartSignal);
		transitionWaitingForTurnToWaitingForTurn1.addAction(cooperateAction);
		transitionWaitingForTurnToWaitingForTurn2.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn2.setGuardCondition(isC);
		transitionWaitingForTurnToWaitingForTurn2.addAction(
			probabilisticAction);

		//connection of transitions
		transitionWaitingForTurnToWaitingForTurn.setSourceState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn.setTargetState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn1.setSourceState(
			waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn1.setTargetState(
			waitingForTurn);
		transitionInitialStateToWaitingForTurn.setSourceState(initialState);
		transitionInitialStateToWaitingForTurn.setTargetState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn2.setSourceState(
			waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn2.setTargetState(
			waitingForTurn);

	}

	/**
	*probabilisticAction
	*/
	protected abstract void probabilisticAction();
}
