package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.ipd.model.behavior.template.IsMatchResult;

/**
* AbstractManageContestBehavior
*/
public abstract class AbstractManageContestBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTime =
			factory.createCompositeState("WaitingForTime");
		CompositeState readyToMatch =
			factory.createCompositeState("ReadyToMatch");
		CompositeState waitingForMatchResultReport =
			factory.createCompositeState("WaitingForMatchResultReport");
		CompositeState oneMatchFnised =
			factory.createCompositeState("OneMatchFnised");

		//actions
		Action prepareNextContextAction = new Action() {
			public void doAction() {
				prepareNextContextAction();
			}
			public String toString() {
				return "prepareNextContextAction";
			}
		};
		Action reportContestResultAction = new Action() {
			public void doAction() {
				reportContestResultAction();
			}
			public String toString() {
				return "reportContestResultAction";
			}
		};
		Action setNextEntryAction = new Action() {
			public void doAction() {
				setNextEntryAction();
			}
			public String toString() {
				return "setNextEntryAction";
			}
		};
		Action recordMatchResultAction = new Action() {
			public void doAction() {
				recordMatchResultAction();
			}
			public String toString() {
				return "recordMatchResultAction";
			}
		};
		Action startMatchAction = new Action() {
			public void doAction() {
				startMatchAction();
			}
			public String toString() {
				return "startMatchAction";
			}
		};

		//guard-conditions
		GuardCondition hasNextPair = new GuardCondition() {
			public boolean isMatched(Event e) {
				return hasNextPair(e);
			}
		};
		TemplateGuardCondition isMatchResult = new IsMatchResult();
		isMatchResult.setBehavior(this);
		GuardCondition hasNotNextPair = new GuardCondition() {
			public boolean isMatched(Event e) {
				return hasNotNextPair(e);
			}
		};

		//transitions
		Transition transitionOneMatchFnisedToReadyToMatch =
			factory.createTransition();
		Transition transitionReadyToMatchToWaitingForMatchResultReport =
			factory.createTransition();
		Transition transitionOneMatchFnisedToWaitingForTime =
			factory.createTransition();
		Transition transitionWaitingForTimeToReadyToMatch =
			factory.createTransition();
		Transition transitionWaitingForMatchResultReportToOneMatchFnised =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForTime =
			factory.createTransition();

		//states setting
		readyToMatch.addEntryAction(setNextEntryAction);

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitingForTime);
		this.addState(readyToMatch);
		this.addState(waitingForMatchResultReport);
		this.addState(oneMatchFnised);

		//transitions setting
		transitionOneMatchFnisedToReadyToMatch.setGuardCondition(hasNextPair);
		transitionReadyToMatchToWaitingForMatchResultReport.addAction(
			startMatchAction);
		transitionOneMatchFnisedToWaitingForTime.setGuardCondition(
			hasNotNextPair);
		transitionOneMatchFnisedToWaitingForTime.addAction(
			reportContestResultAction);
		transitionOneMatchFnisedToWaitingForTime.addAction(
			prepareNextContextAction);
		transitionWaitingForTimeToReadyToMatch.setEvent(TimeEvent.class);
		transitionWaitingForMatchResultReportToOneMatchFnised.setEvent(
			ChannelEvent.class);
		transitionWaitingForMatchResultReportToOneMatchFnised
			.setGuardCondition(
			isMatchResult);
		transitionWaitingForMatchResultReportToOneMatchFnised.addAction(
			recordMatchResultAction);

		//connection of transitions
		transitionOneMatchFnisedToReadyToMatch.setSourceState(oneMatchFnised);
		transitionOneMatchFnisedToReadyToMatch.setTargetState(readyToMatch);
		transitionReadyToMatchToWaitingForMatchResultReport.setSourceState(
			readyToMatch);
		transitionReadyToMatchToWaitingForMatchResultReport.setTargetState(
			waitingForMatchResultReport);
		transitionOneMatchFnisedToWaitingForTime.setSourceState(oneMatchFnised);
		transitionOneMatchFnisedToWaitingForTime.setTargetState(waitingForTime);
		transitionWaitingForTimeToReadyToMatch.setSourceState(waitingForTime);
		transitionWaitingForTimeToReadyToMatch.setTargetState(readyToMatch);
		transitionWaitingForMatchResultReportToOneMatchFnised.setSourceState(
			waitingForMatchResultReport);
		transitionWaitingForMatchResultReportToOneMatchFnised.setTargetState(
			oneMatchFnised);
		transitionInitialStateToWaitingForTime.setSourceState(initialState);
		transitionInitialStateToWaitingForTime.setTargetState(waitingForTime);

	}

	/**
	*prepareNextContextAction
	*/
	protected abstract void prepareNextContextAction();
	/**
	*reportContestResultAction
	*/
	protected abstract void reportContestResultAction();
	/**
	*setNextEntryAction
	*/
	protected abstract void setNextEntryAction();
	/**
	*recordMatchResultAction
	*/
	protected abstract void recordMatchResultAction();
	/**
	*startMatchAction
	*/
	protected abstract void startMatchAction();
	/**
	*hasNextPair
	*/
	protected abstract boolean hasNextPair(Event e);
	/**
	*hasNotNextPair
	*/
	protected abstract boolean hasNotNextPair(Event e);
}
