package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateAction;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.ipd.model.behavior.template.CooperateAction;
import org.boxed_economy.ipd.model.behavior.template.DefectAction;
import org.boxed_economy.ipd.model.behavior.template.IsCorD;
import org.boxed_economy.ipd.model.behavior.template.IsStartSignal;

/**
* AbstractPERCCDStrategyBehavior
*/
public abstract class AbstractPERCCDStrategyBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTurn =
			factory.createCompositeState("WaitingForTurn");
		State initialState1 = factory.createInitialState();
		CompositeState decidingToCooperate1 =
			factory.createCompositeState("DecidingToCooperate1");
		CompositeState decidingToCooperate2 =
			factory.createCompositeState("DecidingToCooperate2");
		CompositeState decidingToDefect =
			factory.createCompositeState("DecidingToDefect");

		//actions
		TemplateAction cooperateAction = new CooperateAction();
		cooperateAction.setBehavior(this);
		TemplateAction defectAction = new DefectAction();
		defectAction.setBehavior(this);

		//guard-conditions
		TemplateGuardCondition isStartSignal = new IsStartSignal();
		isStartSignal.setBehavior(this);
		TemplateGuardCondition isCorD = new IsCorD();
		isCorD.setBehavior(this);

		//transitions
		Transition transitionWaitingForTurnToWaitingForTurn =
			factory.createTransition();
		Transition transitionDecidingToCooperate1ToDecidingToDefect =
			factory.createTransition();
		Transition transitionDecidingToCooperate2ToDecidingToCooperate1 =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForTurn =
			factory.createTransition();
		Transition transitionDecidingToDefectToDecidingToCooperate2 =
			factory.createTransition();
		Transition transitionInitialStateToDecidingToCooperate1 =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		waitingForTurn.setInitialState(initialState1);
		waitingForTurn.addState(decidingToCooperate1);
		waitingForTurn.addState(decidingToCooperate2);
		waitingForTurn.addState(decidingToDefect);
		this.addState(waitingForTurn);

		//transitions setting
		transitionWaitingForTurnToWaitingForTurn.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn.setGuardCondition(
			isStartSignal);
		transitionWaitingForTurnToWaitingForTurn.addAction(cooperateAction);
		transitionDecidingToCooperate1ToDecidingToDefect.setEvent(
			ChannelEvent.class);
		transitionDecidingToCooperate1ToDecidingToDefect.setGuardCondition(
			isCorD);
		transitionDecidingToCooperate1ToDecidingToDefect.addAction(
			cooperateAction);
		transitionDecidingToCooperate2ToDecidingToCooperate1.setEvent(
			ChannelEvent.class);
		transitionDecidingToCooperate2ToDecidingToCooperate1.setGuardCondition(
			isCorD);
		transitionDecidingToCooperate2ToDecidingToCooperate1.addAction(
			cooperateAction);
		transitionDecidingToDefectToDecidingToCooperate2.setEvent(
			ChannelEvent.class);
		transitionDecidingToDefectToDecidingToCooperate2.setGuardCondition(
			isCorD);
		transitionDecidingToDefectToDecidingToCooperate2.addAction(
			defectAction);

		//connection of transitions
		transitionWaitingForTurnToWaitingForTurn.setSourceState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn.setTargetState(waitingForTurn);
		transitionDecidingToCooperate1ToDecidingToDefect.setSourceState(
			decidingToCooperate1);
		transitionDecidingToCooperate1ToDecidingToDefect.setTargetState(
			decidingToDefect);
		transitionDecidingToCooperate2ToDecidingToCooperate1.setSourceState(
			decidingToCooperate2);
		transitionDecidingToCooperate2ToDecidingToCooperate1.setTargetState(
			decidingToCooperate1);
		transitionInitialStateToWaitingForTurn.setSourceState(initialState);
		transitionInitialStateToWaitingForTurn.setTargetState(waitingForTurn);
		transitionDecidingToDefectToDecidingToCooperate2.setSourceState(
			decidingToDefect);
		transitionDecidingToDefectToDecidingToCooperate2.setTargetState(
			decidingToCooperate2);
		transitionInitialStateToDecidingToCooperate1.setSourceState(
			initialState1);
		transitionInitialStateToDecidingToCooperate1.setTargetState(
			decidingToCooperate1);

	}

}
