package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateAction;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.ipd.model.behavior.template.CooperateAction;
import org.boxed_economy.ipd.model.behavior.template.DefectAction;
import org.boxed_economy.ipd.model.behavior.template.IsCorD;
import org.boxed_economy.ipd.model.behavior.template.IsStartSignal;

/**
* AbstractPERCDStrategyBehavior
*/
public abstract class AbstractPERCDStrategyBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTurn =
			factory.createCompositeState("WaitingForTurn");
		State initialState1 = factory.createInitialState();
		CompositeState decidingToDefect =
			factory.createCompositeState("DecidingToDefect");
		CompositeState decidingToCooperate =
			factory.createCompositeState("DecidingToCooperate");

		//actions
		TemplateAction cooperateAction = new CooperateAction();
		cooperateAction.setBehavior(this);
		TemplateAction defectAction = new DefectAction();
		defectAction.setBehavior(this);

		//guard-conditions
		TemplateGuardCondition isStartSignal = new IsStartSignal();
		isStartSignal.setBehavior(this);
		TemplateGuardCondition isCorD = new IsCorD();
		isCorD.setBehavior(this);

		//transitions
		Transition transitionDecidingToDefectToDecidingToCooperate =
			factory.createTransition();
		Transition transitionDecidingToCooperateToDecidingToDefect =
			factory.createTransition();
		Transition transitionWaitingForTurnToWaitingForTurn =
			factory.createTransition();
		Transition transitionInitialStateToDecidingToDefect =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForTurn =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		waitingForTurn.setInitialState(initialState1);
		waitingForTurn.addState(decidingToDefect);
		waitingForTurn.addState(decidingToCooperate);
		this.addState(waitingForTurn);

		//transitions setting
		transitionDecidingToDefectToDecidingToCooperate.setEvent(
			ChannelEvent.class);
		transitionDecidingToDefectToDecidingToCooperate.setGuardCondition(
			isCorD);
		transitionDecidingToDefectToDecidingToCooperate.addAction(defectAction);
		transitionDecidingToCooperateToDecidingToDefect.setEvent(
			ChannelEvent.class);
		transitionDecidingToCooperateToDecidingToDefect.setGuardCondition(
			isCorD);
		transitionDecidingToCooperateToDecidingToDefect.addAction(
			cooperateAction);
		transitionWaitingForTurnToWaitingForTurn.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn.setGuardCondition(
			isStartSignal);
		transitionWaitingForTurnToWaitingForTurn.addAction(cooperateAction);

		//connection of transitions
		transitionDecidingToDefectToDecidingToCooperate.setSourceState(
			decidingToDefect);
		transitionDecidingToDefectToDecidingToCooperate.setTargetState(
			decidingToCooperate);
		transitionDecidingToCooperateToDecidingToDefect.setSourceState(
			decidingToCooperate);
		transitionDecidingToCooperateToDecidingToDefect.setTargetState(
			decidingToDefect);
		transitionWaitingForTurnToWaitingForTurn.setSourceState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn.setTargetState(waitingForTurn);
		transitionInitialStateToDecidingToDefect.setSourceState(initialState1);
		transitionInitialStateToDecidingToDefect.setTargetState(
			decidingToDefect);
		transitionInitialStateToWaitingForTurn.setSourceState(initialState);
		transitionInitialStateToWaitingForTurn.setTargetState(waitingForTurn);

	}

}
