package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractPlayerBehavior
*/
public abstract class AbstractPlayerBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTurn =
			factory.createCompositeState("WaitingForTurn");
		CompositeState thinking = factory.createCompositeState("Thinking");

		//actions
		Action forwardToStrategyAction = new Action() {
			public void doAction() {
				forwardToStrategyAction();
			}
			public String toString() {
				return "forwardToStrategyAction";
			}
		};
		Action memoryOpponentDecisionAction = new Action() {
			public void doAction() {
				memoryOpponentDecisionAction();
			}
			public String toString() {
				return "memoryOpponentDecisionAction";
			}
		};
		Action sendMyDecisionAction = new Action() {
			public void doAction() {
				sendMyDecisionAction();
			}
			public String toString() {
				return "sendMyDecisionAction";
			}
		};

		//guard-conditions
		GuardCondition isDecision = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isDecision(e);
			}
		};
		GuardCondition isAskDecision = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isAskDecision(e);
			}
		};

		//transitions
		Transition transitionInitialStateToWaitingForTurn =
			factory.createTransition();
		Transition transitionWaitingForTurnToWaitingForTurn =
			factory.createTransition();
		Transition transitionThinkingToWaitingForTurn =
			factory.createTransition();
		Transition transitionWaitingForTurnToThinking =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitingForTurn);
		this.addState(thinking);

		//transitions setting
		transitionWaitingForTurnToWaitingForTurn.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn.setGuardCondition(isDecision);
		transitionWaitingForTurnToWaitingForTurn.addAction(
			memoryOpponentDecisionAction);
		transitionThinkingToWaitingForTurn.setEvent(ChannelEvent.class);
		transitionThinkingToWaitingForTurn.setGuardCondition(isDecision);
		transitionThinkingToWaitingForTurn.addAction(sendMyDecisionAction);
		transitionWaitingForTurnToThinking.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToThinking.setGuardCondition(isAskDecision);
		transitionWaitingForTurnToThinking.addAction(forwardToStrategyAction);

		//connection of transitions
		transitionInitialStateToWaitingForTurn.setSourceState(initialState);
		transitionInitialStateToWaitingForTurn.setTargetState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn.setSourceState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn.setTargetState(waitingForTurn);
		transitionThinkingToWaitingForTurn.setSourceState(thinking);
		transitionThinkingToWaitingForTurn.setTargetState(waitingForTurn);
		transitionWaitingForTurnToThinking.setSourceState(waitingForTurn);
		transitionWaitingForTurnToThinking.setTargetState(thinking);

	}

	/**
	*forwardToStrategyAction
	*/
	protected abstract void forwardToStrategyAction();
	/**
	*memoryOpponentDecisionAction
	*/
	protected abstract void memoryOpponentDecisionAction();
	/**
	*sendMyDecisionAction
	*/
	protected abstract void sendMyDecisionAction();
	/**
	*isDecision
	*/
	protected abstract boolean isDecision(Event e);
	/**
	*isAskDecision
	*/
	protected abstract boolean isAskDecision(Event e);
}
