package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.ipd.model.behavior.template.IsContestResult;
import org.boxed_economy.ipd.model.behavior.template.IsMatchResult;

/**
* AbstractReceiveResultBehavior
*/
public abstract class AbstractReceiveResultBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForResult =
			factory.createCompositeState("WaitingForResult");

		//actions
		Action memoryCurrentStrategy = new Action() {
			public void doAction() {
				memoryCurrentStrategy();
			}
			public String toString() {
				return "memoryCurrentStrategy";
			}
		};
		Action receiveContestResultAction = new Action() {
			public void doAction() {
				receiveContestResultAction();
			}
			public String toString() {
				return "receiveContestResultAction";
			}
		};
		Action updateScoreAction = new Action() {
			public void doAction() {
				updateScoreAction();
			}
			public String toString() {
				return "updateScoreAction";
			}
		};
		Action receiveMatchResultAction = new Action() {
			public void doAction() {
				receiveMatchResultAction();
			}
			public String toString() {
				return "receiveMatchResultAction";
			}
		};

		//guard-conditions
		TemplateGuardCondition isMatchResult = new IsMatchResult();
		isMatchResult.setBehavior(this);
		TemplateGuardCondition isContestResult = new IsContestResult();
		isContestResult.setBehavior(this);

		//transitions
		Transition transitionInitialStateToWaitingForResult =
			factory.createTransition();
		Transition transitionWaitingForResultToWaitingForResult =
			factory.createTransition();
		Transition transitionWaitingForResultToWaitingForResult1 =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitingForResult);

		//transitions setting
		transitionWaitingForResultToWaitingForResult.setEvent(
			ChannelEvent.class);
		transitionWaitingForResultToWaitingForResult.setGuardCondition(
			isMatchResult);
		transitionWaitingForResultToWaitingForResult.addAction(
			receiveMatchResultAction);
		transitionWaitingForResultToWaitingForResult.addAction(
			updateScoreAction);
		transitionWaitingForResultToWaitingForResult1.setEvent(
			ChannelEvent.class);
		transitionWaitingForResultToWaitingForResult1.setGuardCondition(
			isContestResult);
		transitionWaitingForResultToWaitingForResult1.addAction(
			receiveContestResultAction);
		transitionWaitingForResultToWaitingForResult1.addAction(
			memoryCurrentStrategy);

		//connection of transitions
		transitionInitialStateToWaitingForResult.setSourceState(initialState);
		transitionInitialStateToWaitingForResult.setTargetState(
			waitingForResult);
		transitionWaitingForResultToWaitingForResult.setSourceState(
			waitingForResult);
		transitionWaitingForResultToWaitingForResult.setTargetState(
			waitingForResult);
		transitionWaitingForResultToWaitingForResult1.setSourceState(
			waitingForResult);
		transitionWaitingForResultToWaitingForResult1.setTargetState(
			waitingForResult);

	}

	/**
	*memoryCurrentStrategy
	*/
	protected abstract void memoryCurrentStrategy();
	/**
	*receiveContestResultAction
	*/
	protected abstract void receiveContestResultAction();
	/**
	*updateScoreAction
	*/
	protected abstract void updateScoreAction();
	/**
	*receiveMatchResultAction
	*/
	protected abstract void receiveMatchResultAction();
}
