package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateAction;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.ipd.model.behavior.template.CooperateAction;
import org.boxed_economy.ipd.model.behavior.template.DefectAction;
import org.boxed_economy.ipd.model.behavior.template.IsC;
import org.boxed_economy.ipd.model.behavior.template.IsD;
import org.boxed_economy.ipd.model.behavior.template.IsStartSignal;

/**
* AbstractTF2TStrategyBehavior
*/
public abstract class AbstractTF2TStrategyBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from Boxed Economy Behavior Editor.
	* Don't modify this method.
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitingForTurn =
			factory.createCompositeState("WaitingForTurn");
		State initialState1 = factory.createInitialState();
		CompositeState beforeDefected =
			factory.createCompositeState("BeforeDefected");
		CompositeState afterDefected =
			factory.createCompositeState("AfterDefected");

		//actions
		TemplateAction cooperateAction = new CooperateAction();
		cooperateAction.setBehavior(this);
		TemplateAction defectAction = new DefectAction();
		defectAction.setBehavior(this);

		//guard-conditions
		TemplateGuardCondition isStartSignal = new IsStartSignal();
		isStartSignal.setBehavior(this);
		TemplateGuardCondition isD = new IsD();
		isD.setBehavior(this);
		TemplateGuardCondition isC = new IsC();
		isC.setBehavior(this);

		//transitions
		Transition transitionInitialStateToBeforeDefected =
			factory.createTransition();
		Transition transitionInitialStateToWaitingForTurn =
			factory.createTransition();
		Transition transitionAfterDefectedToAfterDefected =
			factory.createTransition();
		Transition transitionBeforeDefectedToAfterDefected =
			factory.createTransition();
		Transition transitionWaitingForTurnToWaitingForTurn =
			factory.createTransition();
		Transition transitionAfterDefectedToBeforeDefected =
			factory.createTransition();
		Transition transitionBeforeDefectedToBeforeDefected =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		waitingForTurn.setInitialState(initialState1);
		waitingForTurn.addState(beforeDefected);
		waitingForTurn.addState(afterDefected);
		this.addState(waitingForTurn);

		//transitions setting
		transitionAfterDefectedToAfterDefected.setEvent(ChannelEvent.class);
		transitionAfterDefectedToAfterDefected.setGuardCondition(isD);
		transitionAfterDefectedToAfterDefected.addAction(defectAction);
		transitionBeforeDefectedToAfterDefected.setEvent(ChannelEvent.class);
		transitionBeforeDefectedToAfterDefected.setGuardCondition(isD);
		transitionBeforeDefectedToAfterDefected.addAction(cooperateAction);
		transitionWaitingForTurnToWaitingForTurn.setEvent(ChannelEvent.class);
		transitionWaitingForTurnToWaitingForTurn.setGuardCondition(
			isStartSignal);
		transitionWaitingForTurnToWaitingForTurn.addAction(cooperateAction);
		transitionAfterDefectedToBeforeDefected.setEvent(ChannelEvent.class);
		transitionAfterDefectedToBeforeDefected.setGuardCondition(isC);
		transitionAfterDefectedToBeforeDefected.addAction(cooperateAction);
		transitionBeforeDefectedToBeforeDefected.setEvent(ChannelEvent.class);
		transitionBeforeDefectedToBeforeDefected.setGuardCondition(isC);
		transitionBeforeDefectedToBeforeDefected.addAction(cooperateAction);

		//connection of transitions
		transitionInitialStateToBeforeDefected.setSourceState(initialState1);
		transitionInitialStateToBeforeDefected.setTargetState(beforeDefected);
		transitionInitialStateToWaitingForTurn.setSourceState(initialState);
		transitionInitialStateToWaitingForTurn.setTargetState(waitingForTurn);
		transitionAfterDefectedToAfterDefected.setSourceState(afterDefected);
		transitionAfterDefectedToAfterDefected.setTargetState(afterDefected);
		transitionBeforeDefectedToAfterDefected.setSourceState(beforeDefected);
		transitionBeforeDefectedToAfterDefected.setTargetState(afterDefected);
		transitionWaitingForTurnToWaitingForTurn.setSourceState(waitingForTurn);
		transitionWaitingForTurnToWaitingForTurn.setTargetState(waitingForTurn);
		transitionAfterDefectedToBeforeDefected.setSourceState(afterDefected);
		transitionAfterDefectedToBeforeDefected.setTargetState(beforeDefected);
		transitionBeforeDefectedToBeforeDefected.setSourceState(beforeDefected);
		transitionBeforeDefectedToBeforeDefected.setTargetState(beforeDefected);

	}

}
