package org.boxed_economy.ipd.model.behavior;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.informations.IntegerInformation;
import org.boxed_economy.besp.model.fmfw.informations.MessageInformation;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.information.DecisionInformation;
import org.boxed_economy.ipd.model.information.MatchInformation;

/**
 * ConductMatchBehavior
 * 
 * RefereeA1̑ΐissłB
 * ȉݒ肳ꂽΐ񐔕JԂƂ1̑ΐsAʂGg[ĂvC[ƁA
 * MReXgŜissɕ񍐂܂B
 * 
 * EGg[vC[Ɏ߂悤ɑ
 * EvC[̎󂯎
 * Eΐ팋ʂvZ
 * EȎΐ팋ʂvC[ɒm点
 * 
 * @author bam
 * @version $Id: ConductMatchBehavior.java,v 1.7 2004/06/17 05:32:44 bam Exp $
 */
public class ConductMatchBehavior extends AbstractConductMatchBehavior {

	/*************************************
	 * Class variable 
	 *************************************/

	private static final Logger logger =
		Logger.getLogger(ConductMatchBehavior.class.getName());

	/*************************************
	 * Class variable 
	 *************************************/

	//Oo͗pł
	StringBuffer firstPlayerDecisions = new StringBuffer();
	StringBuffer lastPlayerDecisions = new StringBuffer();
	StringBuffer firstPlayerScores = new StringBuffer();
	StringBuffer lastPlayerScores = new StringBuffer();

	/* (non-Javadoc)
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {

	}

	/* (non-Javadoc)
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {

	}

	/****************
	 * Actions 
	 ****************/

	/**
	 * ΐ̎c^[
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#initializeRemainingTurn()
	 */
	protected void initializeRemainingTurnAction() {
		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_RemainingTurnInformation,
			new IntegerInformation(getTurnNumber()));
	}

	/**
	 * 󂯎L
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#registerDecisionAction()
	 */
	protected void registerDecisionAction() {
		MatchInformation currentMatchInformation =
			this.getCurrentMatchInformation();
		DecisionInformation decision =
			(DecisionInformation) this.getReceivedInformation();

		//AgentɑΉL
		currentMatchInformation.memoryDecision(decision.getAgent(), decision);
	}

	/**
	 * Gg[ĂvC[ɍŏ̎悤Ɍ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#askFirstDecisionAction()
	 */
	protected void askFirstDecisionAction() {
		//ΐJñO
		startMatchLog();

		this.sendInformation(
			IPDModel.RELATIONTYPE_EntryRelation,
			IPDModel.BEHAVIORTYPE_PlayerBehavior,
			IPDModel.INFORMATIONTYPE_StartSignalInformation,
			new MessageInformation("Tell Me First Decision!"),
			false);
	}

	/**
	 * Gg[ĂvC[Ɏ̎悤Ɍ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#askNextDecisionAction()
	 */
	protected void askNextDecisionAction() {
		this.sendInformation(
			IPDModel.RELATIONTYPE_EntryRelation,
			IPDModel.BEHAVIORTYPE_PlayerBehavior,
			IPDModel.INFORMATIONTYPE_AskDecisionInformation,
			new MessageInformation("Tell Me Next Hand!"),
			false);
	}

	/**
	 * ꂼ̃vC[ɁAΐ푊肪ǂ̎𑗂Ă
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#reportOpponentDeceision()
	 */
	protected void reportOpponentDeceisionAction() {
		MatchInformation currentMatchInformation =
			this.getCurrentMatchInformation();
		Collection entries =
			this.getAgent().getRelations(IPDModel.RELATIONTYPE_EntryRelation);

		//ΐ푊̎𑗂
		for (Iterator i = entries.iterator(); i.hasNext();) {
			Relation entry = (Relation) i.next();
			Agent player = entry.getTarget();
			Agent opponent =
				currentMatchInformation.getEntryPair().getOpponent(player);
			DecisionInformation opponentDecision =
				currentMatchInformation.getRecentDecision(opponent);

			this.sendInformation(
				entry,
				IPDModel.BEHAVIORTYPE_PlayerBehavior,
				opponentDecision);
		}
	}

	/**
	 * ΐ̌ʂvC[Ǝg̃ReXgissɕ񍐂
	 */
	protected void reportMatchResultAction() {
		//OL^
		matchLog();

		//vC[ɕ
		this.sendInformation(
			IPDModel.RELATIONTYPE_EntryRelation,
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior,
			IPDModel.INFORMATIONTYPE_MatchResultInformation,
			this.getCurrentMatchInformation(),
			false);

		//g̃ReXgissɕ
		this.sendInformation(
			IPDModel.RELATIONTYPE_SelfRelation,
			IPDModel.BEHAVIORTYPE_ManageContestBehavior,
			IPDModel.INFORMATIONTYPE_MatchResultInformation,
			this.getCurrentMatchInformation(),
			false);
	}

	/**
	 * ̃^[̏
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#prepareNextTurn()
	 */
	protected void prepareNextTurnAction() {
		IntegerInformation currentTurn =
			(IntegerInformation) this.getAgent().getInformation(
				IPDModel.INFORMATIONTYPE_RemainingTurnInformation);

		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_RemainingTurnInformation,
			new IntegerInformation(currentTurn.getValue() - 1));

		//OL^
		turnLog();
	}

	/****************
	 * Guard Conditions 
	 ****************/

	/**
	 * ΐJn̐Mǂׂ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#isStartSignal(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean isStartSignal(Event e) {
		return this.receivedInformationEquals(
			IPDModel.INFORMATIONTYPE_StartSignalInformation);
	}

	/**
	 * SẴGg[vC[ԓǂ𒲂ׂ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#areAllRepliesReceived(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean areAllRepliesReceived(Event e) {
		MatchInformation matchInformation = getCurrentMatchInformation();
		return matchInformation.hasTurnFinished();
	}

	/**
	 * ܂ԓĂȂvC[邩ǂ𒲂ׂ
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#areNotAllRepliesReceived(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean areNotAllRepliesReceived(Event e) {
		return !this.areAllRepliesReceived(e);
	}

	/** 
	 * ^[Sďǂ𒲂ׂ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#isFinalTurn(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean isFinalTurn(Event e) {
		return (
			(IntegerInformation) this.getAgent().getInformation(
				IPDModel.INFORMATIONTYPE_RemainingTurnInformation))
			.getValue()
			== 0;
	}

	/** 
	 * ^[SďĂȂǂ𒲂ׂ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior#isNotFinalTurn(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean isNotFinalTurn(Event e) {
		return !isFinalTurn(e);
	}

	/****************
	 * HelperMethod 
	 ****************/

	private int getTurnNumber() {
		World world = this.getWorld();

		try {
			return Integer
				.parseInt(
					world
					.getClass()
					.getMethod("getTurnNumber", new Class[] {
			}).invoke(world, new Object[] {
			}).toString());
		} catch (Exception e) {
			logger.warn(e);
			throw new ModelException("getTurnNumber failed", e);
		}
	}

	private MatchInformation getCurrentMatchInformation() {
		return (MatchInformation) this.getAgent().getInformation(
			IPDModel.INFORMATIONTYPE_CurrentMatchInformation);
	}

	/****************
	 * Log 
	 ****************/

	private void matchLog() {
		MatchInformation currentMatchInformation =
			this.getCurrentMatchInformation();
		Agent firstPlayer =
			currentMatchInformation.getEntryPair().getFirstPlayer();
		Agent lastPlayer =
			currentMatchInformation.getEntryPair().getLastPlayer();
		String playerA =
			firstPlayer
				.getInformation(IPDModel.INFORMATIONTYPE_NameInformation)
				.toString();
		String playerB =
			lastPlayer
				.getInformation(IPDModel.INFORMATIONTYPE_NameInformation)
				.toString();

		logger.info(
			getStyledText(playerA + "Decision:")
				+ firstPlayerDecisions.toString());
		logger.info(
			getStyledText(playerA + "Score:") + firstPlayerScores.toString());
		logger.info(
			getStyledText(playerB + "Decision:")
				+ lastPlayerDecisions.toString());
		logger.info(
			getStyledText(playerB + "Score:") + lastPlayerScores.toString());

		String playerAStrategy =
			((Behavior) ((List) firstPlayer
				.getBehaviorsRecursively(
					IPDModel.BEHAVIORTYPE_StrategyBehavior))
				.get(0))
				.getType()
				.toString();
		String playerBStrategy =
			((Behavior) ((List) lastPlayer
				.getBehaviorsRecursively(
					IPDModel.BEHAVIORTYPE_StrategyBehavior))
				.get(0))
				.getType()
				.toString();
		String playerAScore =
			String.valueOf(currentMatchInformation.getResultScore(firstPlayer));
		String playerBScore =
			String.valueOf(currentMatchInformation.getResultScore(lastPlayer));

		Agent winner = currentMatchInformation.getWinner();
		if (winner == firstPlayer) {
			logger.info(
				"[<WIN:"
					+ playerAScore
					+ ">"
					+ playerA
					+ "("
					+ trimStrategyBehaviorName(playerAStrategy)
					+ ")"
					+ "~<LOSE:"
					+ playerBScore
					+ ">"
					+ playerB
					+ "("
					+ trimStrategyBehaviorName(playerBStrategy)
					+ ")"
					+ "]");
		} else if (winner == lastPlayer) {
			logger.info(
				"[<LOSE:"
					+ playerAScore
					+ ">"
					+ playerA
					+ "("
					+ trimStrategyBehaviorName(playerAStrategy)
					+ ")"
					+ "~<WIN:"
					+ playerBScore
					+ ">"
					+ playerB
					+ "("
					+ trimStrategyBehaviorName(playerBStrategy)
					+ ")"
					+ "]");
		} else {
			logger.info(
				"[<DRAW:"
					+ playerAScore
					+ ">"
					+ playerA
					+ "("
					+ trimStrategyBehaviorName(playerAStrategy)
					+ ")"
					+ "~<DRAW:"
					+ playerBScore
					+ ">"
					+ playerB
					+ "("
					+ trimStrategyBehaviorName(playerBStrategy)
					+ ")"
					+ "]");

		}
	}

	private void turnLog() {
		MatchInformation match = this.getCurrentMatchInformation();

		Agent first = match.getEntryPair().getFirstPlayer();
		firstPlayerDecisions.append(match.getRecentDecision(first).toString());
		firstPlayerScores.append(match.getRecentScore(first));
		Agent last = match.getEntryPair().getLastPlayer();
		lastPlayerDecisions.append(match.getRecentDecision(last).toString());
		lastPlayerScores.append(match.getRecentScore(last));
	}

	private void startMatchLog() {
		firstPlayerDecisions = new StringBuffer();
		lastPlayerDecisions = new StringBuffer();
		firstPlayerScores = new StringBuffer();
		lastPlayerScores = new StringBuffer();

		MatchInformation currentMatchInformation =
			this.getCurrentMatchInformation();
		Agent firstPlayer =
			currentMatchInformation.getEntryPair().getFirstPlayer();
		Agent lastPlayer =
			currentMatchInformation.getEntryPair().getLastPlayer();

		String playerA =
			firstPlayer
				.getInformation(IPDModel.INFORMATIONTYPE_NameInformation)
				.toString();
		String playerB =
			lastPlayer
				.getInformation(IPDModel.INFORMATIONTYPE_NameInformation)
				.toString();
		String playerAStrategy =
			((Behavior) ((List) firstPlayer
				.getBehaviorsRecursively(
					IPDModel.BEHAVIORTYPE_StrategyBehavior))
				.get(0))
				.getType()
				.toString();
		String playerBStrategy =
			((Behavior) ((List) lastPlayer
				.getBehaviorsRecursively(
					IPDModel.BEHAVIORTYPE_StrategyBehavior))
				.get(0))
				.getType()
				.toString();
		logger.info("");
		logger.info(
			"["
				+ playerA
				+ "("
				+ trimStrategyBehaviorName(playerAStrategy)
				+ ")"
				+ "~"
				+ playerB
				+ "("
				+ trimStrategyBehaviorName(playerBStrategy)
				+ ")"
				+ "]");
	}

	private String trimStrategyBehaviorName(String strategyTypeName) {
		int start = strategyTypeName.lastIndexOf('.') + 1;
		int last = strategyTypeName.lastIndexOf("StrategyBehavior");
		return strategyTypeName.substring(start, last);
	}

	private String getStyledText(String text) {
		int length = 20;
		int textLength = text.length();
		StringBuffer result = new StringBuffer(text);

		for (int i = 0; i < length - textLength; i++) {
			result.append(" ");
		}

		return result.toString();
	}

}
