package org.boxed_economy.ipd.model.behavior;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.informations.IntegerInformation;
import org.boxed_economy.besp.model.fmfw.informations.MessageInformation;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.information.ContestInformation;
import org.boxed_economy.ipd.model.information.MatchInformation;
import org.boxed_economy.ipd.model.information.MatchPairInformation;
import org.boxed_economy.ipd.model.information.MatchPairTableInformation;

/**
 * ManageContestBehavior
 * 
 * RefereeAReXg̐isssłB
 * ȉ̃ANVJԂƂŁÃReXgsAReXgI猋ʂL܂B
 * 
 * EΐyAGg[
 * EΐJn
 * Eΐ팋ʂL(ReXgŜ̌ʂŋL邽)
 * 
 * @author bam
 * @version $Id: ManageContestBehavior.java,v 1.4 2004/06/16 06:45:29 bam Exp $
 */
public class ManageContestBehavior extends AbstractManageContestBehavior {

	/*************************************
	 * Class variable 
	 *************************************/

	private static final Logger logger =
		Logger.getLogger(ManageContestBehavior.class.getName());

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {

	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/****************
	 * Actions 
	 ****************/

	/**
	 * ɑΐsyAGg[܂B
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractManageContestBehavior#setNextEntryAction()
	 */
	protected void setNextEntryAction() {
		//ÕGg[܂
		if (this
			.getAgent()
			.getRelations(IPDModel.RELATIONTYPE_EntryRelation)
			.size()
			> 0) { //ÕGg[
			this.getAgent().removeRelations(
				IPDModel.RELATIONTYPE_EntryRelation);
		}

		//݂̃ReXg̑ΐ\Lo܂B
		MatchPairTableInformation pairTable = getMatchPairTableInformation();

		//̑ΐ̏L܂B
		MatchPairInformation currentMatchPair = pairTable.getNextPair();
		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_CurrentMatchInformation,
			new MatchInformation(currentMatchPair));

		//vC[̃Gg[s܂B
		this.getAgent().addRelation(
			IPDModel.RELATIONTYPE_EntryRelation,
			currentMatchPair.getFirstPlayer());
		this.getAgent().addRelation(
			IPDModel.RELATIONTYPE_EntryRelation,
			currentMatchPair.getLastPlayer());
	}

	/**
	 * ΐJn
	 * @see org.boxed_economy.ipd.model.behavior.AbstractManageContestBehavior#startMatchAction()
	 */
	protected void startMatchAction() {

		//gAΐǗsɑΐJñbZ[W𑗂
		sendInformation(
			IPDModel.RELATIONTYPE_SelfRelation,
			IPDModel.BEHAVIORTYPE_ConductMatchBehavior,
			IPDModel.INFORMATIONTYPE_StartSignalInformation,
			new MessageInformation("Start!"),
			false);
	}

	/**
	 * ΐ̌ʂ݂̃ReXg̏ɒǉ
	 * @see org.boxed_economy.ipd.model.behavior.AbstractManageContestBehavior#recordMatchResultAction()
	 */
	protected void recordMatchResultAction() {
		MatchInformation matchInformation =
			(MatchInformation) this.getReceivedInformation();

		this.getCurrentContestInformation().registMatch(matchInformation);

	}

	/**
	 * ̃ReXǧʂvC[ɒʒm܂
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractManageContestBehavior#reportContestResultAction()
	 */
	protected void reportContestResultAction() {
		this.sendInformation(
			IPDModel.RELATIONTYPE_PlayerRelation,
			IPDModel.BEHAVIORTYPE_ReceiveResultBehavior,
			IPDModel.INFORMATIONTYPE_ContestResultInformation,
			this.getAgent().getInformation(
				IPDModel.INFORMATIONTYPE_CurrentContestInformation),
			false);

		//ReXg̃OL^
		this.contestLog();
	}

	/**
	 * ̃ReXg̏܂
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractManageContestBehavior#prepareNextContextAction()
	 */
	protected void prepareNextContextAction() {

		//ΐ\ɐi߂
		this.getMatchPairTableInformation().toNextContest();

		//^[ɐi߂
		IntegerInformation currentCount =
			(IntegerInformation) this.getAgent().getInformation(
				IPDModel.INFORMATIONTYPE_ContestCountInformation);

		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_ContestCountInformation,
			new IntegerInformation(currentCount.getValue() + 1));
		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_CurrentContestInformation,
			new ContestInformation());
	}

	/****************
	 * Guard Conditions 
	 ****************/

	/**
	 * ̃yA邩ǂ𒲂ׂ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractManageContestBehavior#isLastPair(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean hasNextPair(Event e) {
		return getMatchPairTableInformation().hasNextPair();
	}

	/**
	 * ̃yAȂǂ𒲂ׂ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractManageContestBehavior#isNotLastPair(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean hasNotNextPair(Event e) {
		return !hasNextPair(e);
	}

	/****************
	 * Helper Methods
	 ****************/

	private MatchPairTableInformation getMatchPairTableInformation() {
		return (MatchPairTableInformation) this.getAgent().getInformation(
			IPDModel.INFORMATIONTYPE_MatchPairTableInformation);
	}

	private ContestInformation getCurrentContestInformation() {
		return (ContestInformation) this.getAgent().getInformation(
			IPDModel.INFORMATIONTYPE_CurrentContestInformation);
	}

	/****************
	 * log
	 ****************/

	private void contestLog() {
		//L̎擾
		IntegerInformation contestCount =
			(IntegerInformation) this.getAgent().getInformation(
				IPDModel.INFORMATIONTYPE_ContestCountInformation);
		ContestInformation contestInformation =
			this.getCurrentContestInformation();
		Collection allPlayers =
			this.getWorld().getAgents(IPDModel.AGENTTYPE_PlayerAgent);
		int totalScoreSum = 0;
		List strategies = IPDModel.BEHAVIORTYPE_StrategyBehavior.getChildren();
		HashMap strategyCounts = new HashMap();
		for (Iterator i = strategies.iterator(); i.hasNext();) {
			strategyCounts.put(i.next(), new Integer(0));
		}

		logger.info("");
		logger.info(
			"****************************************************************");
		logger.info(contestCount.getValue() + 1 + "th Contest Result");

		logger.info("");
		logger.info(
			"--------------------Point of Agent on the contest------------------");
		logger.info(
			"|"
				+ getStyledText("Name")
				+ "|"
				+ getStyledText("Behavior")
				+ "|"
				+ getStyledText("GainPoint")
				+ "|"
				+ getStyledText("TotalPoint")
				+ "|");

		//SG[WFgIDAStrategyAl|CgAތ^|Cg
		for (Iterator i = allPlayers.iterator(); i.hasNext();) {
			Agent player = (Agent) i.next();
			IntegerInformation totalScore =
				(IntegerInformation) player.getInformation(
					IPDModel.INFORMATIONTYPE_ScoreInformation);
			int contestScore = contestInformation.getContestScore(player);
			BehaviorType strategy =
				((Behavior) ((List) player
					.getBehaviorsRecursively(
						IPDModel.BEHAVIORTYPE_StrategyBehavior))
					.get(0))
					.getType();
			String strategyName = trimStrategyBehaviorName(strategy.toString());
			String name =
				player
					.getInformation(IPDModel.INFORMATIONTYPE_NameInformation)
					.toString();

			//StrategygĂ邩Z
			Integer current = (Integer) strategyCounts.get(strategy);
			strategyCounts.put(strategy, new Integer(current.intValue() + 1));

			logger.info(
				"|"
					+ getStyledText(name)
					+ "|"
					+ getStyledText(strategyName)
					+ "|"
					+ getStyledText(String.valueOf(contestScore))
					+ "|"
					+ getStyledText(String.valueOf(totalScore))
					+ "|");

			totalScoreSum += totalScore.getValue();
		}

		//SG[WFg̕ϊlXRA
		logger.info("");
		logger.info(
			"--------------------------Average-------------------------------");
		logger.info("GainScoreAverage:" + contestInformation.getAverageScore());
		logger.info("TotalScoreAverage:" + totalScoreSum / allPlayers.size());

		logger.info("");
		logger.info(
			"---------------------Number of each strategy----------------------");
		for (Iterator i = strategyCounts.keySet().iterator(); i.hasNext();) {
			BehaviorType strategy = (BehaviorType) i.next();
			Integer count = (Integer) strategyCounts.get(strategy);

			logger.info(
				this.getStyledText(
					trimStrategyBehaviorName(strategy.toString()))
					+ ":"
					+ count);
		}

		logger.info(
			"****************************************************************");
	}

	private String trimStrategyBehaviorName(String strategyTypeName) {
		int start = strategyTypeName.lastIndexOf('.') + 1;
		int last = strategyTypeName.lastIndexOf("StrategyBehavior");
		return strategyTypeName.substring(start, last);
	}

	private String getStyledText(String text) {
		int length = 10;
		int textLength = text.length();
		StringBuffer result = new StringBuffer(text);

		for (int i = 0; i < length - textLength; i++) {
			result.append(" ");
		}

		return result.toString();
	}

}
