package org.boxed_economy.ipd.model.behavior;

import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.information.DecisionHistoryInformation;
import org.boxed_economy.ipd.model.information.DecisionInformation;

/**
 * PlayerBehavior
 * 
 * vC[Q[słB
 * ۂɂǂ̎oStrategyBehaviorɈϏĂ܂B
 * 
 * @author bam
 * @version $Id: PlayerBehavior.java,v 1.3 2004/06/16 18:35:36 bam Exp $
 */
public class PlayerBehavior extends AbstractPlayerBehavior {

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/****************
	 * Actions 
	 ****************/

	/**
	 * IRefereeɓ`܂
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractPlayerBehavior#sendMyDecisionAction()
	 */
	protected void sendMyDecisionAction() {
		DecisionInformation decision =
			(DecisionInformation) this.getReceivedInformation();
		this.sendInformation(
			IPDModel.RELATIONTYPE_RefereeRelation,
			IPDModel.BEHAVIORTYPE_ConductMatchBehavior,
			decision);
	}

	/**
	 * Referee瑗ĂStrategyBehaviorɓ]܂
	 * @see org.boxed_economy.ipd.model.behavior.AbstractPlayerBehavior#forwardToStrategyAction()
	 */
	protected void forwardToStrategyAction() {
		Goods receivedGoods = this.getReceivedGoods();
		InformationType type = null;
		if (receivedGoods.getAttachmentKey() instanceof InformationType) {
			type = (InformationType) receivedGoods.getAttachmentKey();
		} else {
			type = this.getWorld().getInformationType(getReceivedInformation());
		}

		this.sendInformation(
			IPDModel.RELATIONTYPE_SelfRelation,
			IPDModel.BEHAVIORTYPE_StrategyBehavior,
			type,
			this.getReceivedInformation(),
			false);
	}

	/**
	 * ̎L
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractPlayerBehavior#memoryOpponentDecision()
	 */
	protected void memoryOpponentDecisionAction() {
		DecisionHistoryInformation history =
			(DecisionHistoryInformation) this.getAgent().getInformation(
				DecisionHistoryInformation.class);

		history.add((DecisionInformation) this.getReceivedInformation());
	}

	/****************
	 * GuardConditions 
	 ****************/

	/**
	 * ̏񂪑Ăǂ𒲂ׂ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractPlayerBehavior#isDecision(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean isDecision(Event e) {
		return this.receivedInformationEquals(
			getWorld().getInformationType(DecisionInformation.class.getName()));
	}

	/**
	 * RefereeɎoƂĂ邩ǂ𒲂ׂ
	 * StartSignalAskDecisionĂƂɑ
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractPlayerBehavior#isAskDecision(org.boxed_economy.besp.model.fmfw.behavior.Event)
	 */
	protected boolean isAskDecision(Event e) {
		return this.receivedInformationEquals(
			IPDModel.INFORMATIONTYPE_StartSignalInformation)
			|| this.receivedInformationEquals(
				IPDModel.INFORMATIONTYPE_AskDecisionInformation);
	}

}
