package org.boxed_economy.ipd.model.behavior;

import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.informations.IntegerInformation;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.information.MatchInformation;

/**
 * ReceiveResultBehavior
 * 
 * ʂ̑ΐ팋ʂƁAReXg̑Ŝ̌ʂosł
 * 
 * @author bam
 * @version $Id: ReceiveResultBehavior.java,v 1.4 2004/06/16 14:29:44 bam Exp $
 */
public class ReceiveResultBehavior extends AbstractReceiveResultBehavior {

	/*************************************
	 * Class variable 
	 *************************************/

	private static final Logger logger =
		Logger.getLogger(ReceiveResultBehavior.class.getName());

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/****************
	 * Actions 
	 ****************/

	/**
	 * ΐ̌ʂ󂯎ċL܂
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractReceiveResultBehavior#redeiveMatchResultAction()
	 */
	protected void receiveMatchResultAction() {
		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_CurrentMatchInformation,
			this.getReceivedInformation());
	}

	/**
	 * ΐ̌ʂ󂯎ċL܂
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractReceiveResultBehavior#updateScoreAction()
	 */
	protected void updateScoreAction() {
		MatchInformation lastMatch =
			(MatchInformation) this.getAgent().getInformation(
				IPDModel.INFORMATIONTYPE_CurrentMatchInformation);

		int result = lastMatch.getResultScore(this.getAgent());
		IntegerInformation currentScore =
			(IntegerInformation) this.getAgent().getInformation(
				IPDModel.INFORMATIONTYPE_ScoreInformation);

		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_ScoreInformation,
			new IntegerInformation(currentScore.getValue() + result));
	}

	/**
	 * ReXǧʂ󂯎ċL܂
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractReceiveResultBehavior#receiveContestResultAction()
	 */
	protected void receiveContestResultAction() {
		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_CurrentContestInformation,
			this.getReceivedInformation());
	}

	/**
	 * ReXǧʂ󂯎ƂɁAŋ߂̃ReXgŎgp헪oĂ܂B
	 * 
	 * @see org.boxed_economy.ipd.model.behavior.AbstractReceiveResultBehavior#memoryCurrentStrategy()
	 */
	protected void memoryCurrentStrategy() {
		BehaviorType currentStrategyType =
			((Behavior) ((List) this
				.getAgent()
				.getBehaviorsRecursively(
					IPDModel.BEHAVIORTYPE_StrategyBehavior))
				.get(0))
				.getType();

		this.getAgent().putInformation(
			IPDModel.INFORMATIONTYPE_CurrentStrategyInformation,
			currentStrategyType);
	}

}
