package org.boxed_economy.ipd.model.behavior.template;

import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.behavior.TemplateAction;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.information.WinnerListInformation;

/**
 * ChangeStrategyAction
 * 
 * LĂ鐬уLȌʂ̑̃v[[̐헪͕킷
 * 
 * @author bam
 * @version $Id: ChangeStrategyAction.java,v 1.5 2004/06/16 06:50:53 bam Exp $
 */
public class ChangeStrategyAction extends TemplateAction {

	/*************************************
	 * Class variable 
	 *************************************/

	private static final Logger logger =
		Logger.getLogger(ChangeStrategyAction.class.getName());

	/***************************
	 * Constructor(s)
	 ***************************/
	public ChangeStrategyAction() {
		super();
	}

	/**
	 * LĂ鐬уLȌʂ̑̃v[[̐헪͕킷
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.behavior.Action#doAction()
	 */
	public void doAction() {

		//ÕReXg̐яʎ҂̃XgLo
		WinnerListInformation winnerListInformation =
			(WinnerListInformation) this
				.getBehavior()
				.getAgent()
				.getInformation(
				WinnerListInformation.class);
		List winnerList = winnerListInformation.getWinners();

		if (!winnerList.isEmpty()) {
			int size = winnerList.size();
			int randomNum =
				this
					.getBehavior()
					.getWorld()
					.getRandomNumberGenerator()
					.generate(
					size);
			Agent target = (Agent) winnerList.get(randomNum);

			BehaviorType currentStrategyType =
				(BehaviorType) this.getBehavior().getAgent().getInformation(
					IPDModel.INFORMATIONTYPE_CurrentStrategyInformation);
			BehaviorType newStrategyType =
				(BehaviorType) target.getInformation(
					IPDModel.INFORMATIONTYPE_CurrentStrategyInformation);

			//݂StrategyBehavior̍폜
			this.getBehavior().getAgent().removeBehavior(
				this.getBehavior().getAgent().getBehavior(currentStrategyType));

			//Vs̒ǉ			
			this.getBehavior().getAgent().addBehavior(newStrategyType);

			changeStrategyLog(currentStrategyType, newStrategyType, winnerList);
		} else {
			BehaviorType currentStrategyType =
				(BehaviorType) this.getBehavior().getAgent().getInformation(
					IPDModel.INFORMATIONTYPE_CurrentStrategyInformation);

			changeStrategyLog(
				currentStrategyType,
				currentStrategyType,
				winnerList);
		}
	}

	/****************
	 * Log 
	 ****************/

	private void changeStrategyLog(
		BehaviorType currentStrategyType,
		BehaviorType newStrategyType,
		List winners) {
		String name =
			this
				.getBehavior()
				.getAgent()
				.getInformation(IPDModel.INFORMATIONTYPE_NameInformation)
				.toString();
		StringBuffer candidate = new StringBuffer();
		for (Iterator i = winners.iterator(); i.hasNext();) {
			Agent candidatePlayer = (Agent) i.next();
			BehaviorType strategyType =
				(BehaviorType) candidatePlayer.getInformation(
					IPDModel.INFORMATIONTYPE_CurrentStrategyInformation);
			candidate.append(trimStrategyBehaviorName(strategyType.toString()));
			if (i.hasNext()) {
				candidate.append(',');
			}
		}

		if (currentStrategyType == newStrategyType) {
			logger.info(
				getStyledText(name)
					+ ":"
					+ getStyledText(
						trimStrategyBehaviorName(
							currentStrategyType.toString()))
					+ "--> no change("
					+ candidate.toString()
					+ ")");
		} else {
			logger.info(
				getStyledText(name)
					+ ":"
					+ getStyledText(
						trimStrategyBehaviorName(
							currentStrategyType.toString()))
					+ "-->"
					+ getStyledText(
						trimStrategyBehaviorName(newStrategyType.toString()))
					+ "("
					+ candidate.toString()
					+ ")");
		}
	}

	private String trimStrategyBehaviorName(String strategyTypeName) {
		int start = strategyTypeName.lastIndexOf('.') + 1;
		int last = strategyTypeName.lastIndexOf("StrategyBehavior");
		return strategyTypeName.substring(start, last);
	}

	private String getStyledText(String text) {
		int length = 10;
		int textLength = text.length();
		StringBuffer result = new StringBuffer(text);

		for (int i = 0; i < length - textLength; i++) {
			result.append(" ");
		}

		return result.toString();
	}
}
