package org.boxed_economy.ipd.model.behavior.template;

import org.boxed_economy.besp.model.fmfw.behavior.TemplateAction;
import org.boxed_economy.ipd.model.information.DecisionHistoryInformation;
import org.boxed_economy.ipd.model.information.DecisionInformation;

/**
 * ImitateAction
 * 
 * ̎̐^Ď̎oANVł
 * 
 * @author bam
 * @version $Id: ImitateAction.java,v 1.1 2004/06/15 13:10:38 bam Exp $
 */
public class ImitateAction extends TemplateAction {

	/***************************
	 * Constructor(s)
	 ***************************/
	public ImitateAction() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.Action#doAction()
	 */
	public void doAction() {

		this.getBehavior().sendInformation(
			new DecisionInformation(
				this.getBehavior().getAgent(),
				getOpponentRecentDecision().getDecision()));
	}

	/**
	 * ΐ푊̑O̎擾
	 * 
	 * @return
	 */
	protected DecisionInformation getOpponentRecentDecision() {
		DecisionHistoryInformation history = getOpponentDecisionHistory();

		return history.getLast();
	}

	/**
	 * ΐ푊̑O̗̎擾
	 * 
	 * @return
	 */
	protected DecisionHistoryInformation getOpponentDecisionHistory() {
		return (DecisionHistoryInformation) this
			.getBehavior()
			.getAgent()
			.getInformation(
				getBehavior().getWorld().getInformationType(
					DecisionHistoryInformation.class.getName()));
	}
}
