/*
* ContestInformation.java
*/
package org.boxed_economy.ipd.model.information;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.AbstractInformation;
import org.boxed_economy.besp.model.fmfw.Agent;

/**
 * ReXg̏L邽߂Informationł
 *
 * @generated modifiable
 * @version $$Id: ContestInformation.java,v 1.3 2004/06/15 16:34:46 bam Exp $$
 */
public class ContestInformation extends AbstractInformation {

	/***************************
	 * Instance Variable(s)
	 ***************************/

	private HashMap winners = new HashMap();
	private List matches = new ArrayList();
	private HashMap scores = new HashMap();

	private List sortedAgents;
	private boolean isFinished = false;

	/***************************
	 * Operation(s)
	 ***************************/

	/**
	 * ΐo^܂
	 * 
	 * @generated modifiable
	 */
	public void registMatch(MatchInformation match) {
		if (isFinished) {
			throw new ModelException("this contest is already finished" + this);
		}

		this.matches.add(match);

		//҂o^
		Agent winner = match.getWinner();
		Agent loser = match.getLoser();
		if (winner != null) { //̏ꍇ͓o^Ȃ

			//҂̃Xgpӂ
			List winnerList = (List) this.winners.get(loser);
			if (winnerList == null) {
				winnerList = new ArrayList();
				this.winners.put(loser, winnerList);
			}

			//҂o^
			winnerList.add(winner);
		}

		addScore(match, match.getEntryPair().getFirstPlayer());
		addScore(match, match.getEntryPair().getLastPlayer());
	}

	/**
	 * w肳ꂽvC[_ʂ̃vC[擾
	 */
	public WinnerListInformation getHighScorePlayers(Agent player) {
		this.isFinished = true;

		if (sortedAgents == null) {
			List allAgents = new ArrayList(this.scores.keySet());
			Collections.sort(allAgents, new AgentComparatorWithScore());

			this.sortedAgents = allAgents;
		}

		List headAgents =
			sortedAgents.subList(
				0,
				Collections.binarySearch(
					sortedAgents,
					player,
					new AgentComparatorWithScore()));

		int lastIndex = headAgents.size() - 1;
		while (true) {
			if (headAgents.isEmpty()) {
				break;
			}

			Agent lastAgent = (Agent) headAgents.get(lastIndex);
			int lastAgentScore =
				((Integer) this.scores.get(lastAgent)).intValue();
			int targetScore = ((Integer) this.scores.get(player)).intValue();

			if (lastAgentScore == targetScore) {
				headAgents.remove(lastIndex);
				lastIndex--;
			} else {
				break;
			}
		}

		return new WinnerListInformation(headAgents);
	}

	/**
	 * w肳ꂽvC[ɏvC[擾
	 */
	public WinnerListInformation getStrongerPlayers(Agent player) {
		this.isFinished = true;

		List winners = (List) this.winners.get(player);

		if (winners == null) {
			return new WinnerListInformation(new ArrayList());
		} else {
			return new WinnerListInformation(winners);
		}
	}

	/**
	 * w肳ꂽvC[̃ReXgł̌ʂ擾܂
	 */
	public int getContestScore(Agent player) {
		Integer score = (Integer) this.scores.get(player);

		return score.intValue();
	}

	/**
	 * ReXg̕σXRA擾܂
	 */
	public int getAverageScore() {
		Collection scores = this.scores.values();
		int sum = 0;
		for (Iterator i = scores.iterator(); i.hasNext();) {
			Integer score = (Integer) i.next();
			sum += score.intValue();
		}

		if (sum == 0) {
			return 0;
		}
		return sum / scores.size();
	}

	/***************************
	 * Subroutine(s)
	 ***************************/

	private void addScore(MatchInformation match, Agent player) {
		Integer score = (Integer) this.scores.get(player);

		if (score == null) {
			score = new Integer(match.getResultScore(player));
		} else {
			score =
				new Integer(score.intValue() + match.getResultScore(player));
		}

		this.scores.put(player, score);
	}

	/***************************
	 * inner class(s)
	 ***************************/

	class AgentComparatorWithScore implements Comparator {
		public int compare(Object o1, Object o2) {
			Integer score1 = (Integer) scores.get(o1);
			Integer score2 = (Integer) scores.get(o2);

			return -1 * score1.compareTo(score2);
		}
	}

	//test
	public static void main(String args[]) {
		TreeSet set = new TreeSet();

		set.add(new Integer(1));
		set.add(new Integer(2));
		set.add(new Integer(3));
		Integer san = new Integer(3);
		set.add(san);
		set.add(new Integer(3));
		set.add(new Integer(4));

		List list = new ArrayList(set);
		List tailSet = new ArrayList(set.tailSet(san));
		List headSet = new ArrayList(set.headSet(san));
		int a = 0;
	}

}