/*
* MatchInformation.java
*/
package org.boxed_economy.ipd.model.information;

import java.util.LinkedList;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.AbstractInformation;
import org.boxed_economy.besp.model.fmfw.Agent;

/**
 * MatchInformation
 * 
 * ΐ̏LInformationł
 *
 * @generated modifiable
 * @version $$Id: MatchInformation.java,v 1.2 2004/06/15 16:34:46 bam Exp $$
 */
public class MatchInformation extends AbstractInformation {

	/***************************
	 * Instance Variable(s)
	 ***************************/

	private MatchPairInformation entryPair;
	private LinkedList firstPlayerDecisions = new LinkedList();
	private LinkedList lastPlayerDecisions = new LinkedList();

	private int firstPlayerScore = 0;
	private int lastPlayerScore = 0;

	private int recentFirstPlayerScore = 0;
	private int recentSecondPlayerScore = 0;

	private Agent winner;

	/***************************
	 * Constructor(s)
	 ***************************/

	public MatchInformation(MatchPairInformation entryPair) {
		this.entryPair = entryPair;
	}

	/***************************
	 * Operation(s)
	 ***************************/

	/**
	 * ΐɃGg[ĂyA擾܂
	 * 
	 * @generated modifiable
	 */
	public MatchPairInformation getEntryPair() {
		return this.entryPair;
	}

	/**
	 * vC[oL^܂
	 * 
	 * @generated modifiable
	 */
	public void memoryDecision(Agent player, DecisionInformation decision) {
		//L^
		if (player == this.entryPair.getFirstPlayer()) {
			this.firstPlayerDecisions.add(decision);
		} else if (player == this.entryPair.getLastPlayer()) {
			this.lastPlayerDecisions.add(decision);
		} else {
			throw new ModelException("this agent is not entry player" + player);
		}

		//^[IĂ琬тZ
		if (hasTurnFinished()) {
			this.recentFirstPlayerScore =
				this.calculateScore(
					(DecisionInformation) this.firstPlayerDecisions.getLast(),
					(DecisionInformation) this.lastPlayerDecisions.getLast());
			this.recentSecondPlayerScore =
				this.calculateScore(
					(DecisionInformation) this.lastPlayerDecisions.getLast(),
					(DecisionInformation) this.firstPlayerDecisions.getLast());

			this.firstPlayerScore += recentFirstPlayerScore;
			this.lastPlayerScore += recentSecondPlayerScore;
		}
	}

	/**
	 * õvC[̎肪L^A1^[̏񂪋L^ꂽԂǂ𒲂ׂ܂
	 * 
	 * @generated modifiable
	 */
	public boolean hasTurnFinished() {
		return !this.firstPlayerDecisions.isEmpty()
			&& this.firstPlayerDecisions.size() == lastPlayerDecisions.size();
	}

	/**
	 * w肳ꂽvC[̒O̎擾܂
	 * 
	 * @generated modifiable
	 */
	public DecisionInformation getRecentDecision(Agent player) {
		if (player == this.entryPair.getFirstPlayer()) {
			return (DecisionInformation) this.firstPlayerDecisions.getLast();
		} else if (player == this.entryPair.getLastPlayer()) {
			return (DecisionInformation) this.lastPlayerDecisions.getLast();
		}

		throw new ModelException("this agent is not entry player" + player);
	}

	/**
	 * w肳ꂽvC[̒ÕXRA擾܂
	 * 
	 * @generated modifiable
	 */
	public int getRecentScore(Agent player) {
		if (player == this.entryPair.getFirstPlayer()) {
			return recentFirstPlayerScore;
		} else if (player == this.entryPair.getLastPlayer()) {
			return recentSecondPlayerScore;
		}

		throw new ModelException("this agent is not entry player" + player);
	}

	/**
	 * w肳ꂽvC[̂̑ΐ̌ʂ擾܂
	 */
	public int getResultScore(Agent player) {
		if (!hasTurnFinished()) {
			throw new ModelException("this match is not completed" + this);
		}

		if (player == this.entryPair.getFirstPlayer()) {
			return firstPlayerScore;
		} else if (player == this.entryPair.getLastPlayer()) {
			return lastPlayerScore;
		}

		throw new ModelException("this agent is not entry player" + player);
	}

	/**
	 * ΐ̏҂擾܂
	 */
	public Agent getWinner() {
		if (!hasTurnFinished()) {
			throw new ModelException("this match is not completed" + this);
		}

		if (this.firstPlayerScore > lastPlayerScore) {
			return entryPair.getFirstPlayer();
		} else if (this.firstPlayerScore < lastPlayerScore) {
			return entryPair.getLastPlayer();
		} else {
			return null;
		}
	}

	/**
	 * ΐ̔s҂擾܂
	 */
	public Agent getLoser() {
		if (!hasTurnFinished()) {
			throw new ModelException("this match is not completed" + this);
		}

		if (this.firstPlayerScore < lastPlayerScore) {
			return entryPair.getFirstPlayer();
		} else if (this.firstPlayerScore > lastPlayerScore) {
			return entryPair.getLastPlayer();
		} else {
			return null;
		}
	}

	/**
	 * o̎肩猋ʂ̃XRA擾
	 **/
	private int calculateScore(
		DecisionInformation mineDecision,
		DecisionInformation opponentDecision) {
		String mine = mineDecision.getDecision();
		String opponent = opponentDecision.getDecision();

		if (mine.equals("C") && opponent.equals("C")) {
			return 3; //̏ꍇ
		} else if (mine.equals("D") && opponent.equals("D")) {
			return 1; //؂̏ꍇ
		} else if (mine.equals("C") && opponent.equals("D")) {
			return 0; //A肪؂̏ꍇ
		} else if (mine.equals("D") && opponent.equals("C")) {
			return 5; //؂A肪̏ꍇ	
		} else {
			throw new ModelException(
				"Invalid Desicion : mine=" + mine + " opponent=" + opponent);
		}
	}

}