/*
 * IPDBattleViewer.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Channel;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateChannelEvent;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateChannelListener;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateClockEvent;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateStepListener;
import org
	.boxed_economy
	.besp
	.presentation
	.guifw
	.AbstractInternalFrameComponent;
import org.boxed_economy.ipd.model.IPDModel;
import org
	.boxed_economy
	.ipd
	.model
	.information
	.MatchInformation;

/**
 * vC[̑ΐ󋵂\܂
 * 
 * @author tsuya
 * Create on 2004/06/17 16:15:24
 */
public class IPDBattleViewer
	extends AbstractInternalFrameComponent
	implements
		ModelContainerListener,
		UpdateChannelListener,
		UpdateStepListener {

	private IPDBattlePanel panel;

	public IPDBattleViewer() {
		super();
		this.setTitle("IPD Battle Viewer");
		this.setSize(new Dimension(300, 120));

		this.panel = new IPDBattlePanel();
		this.panel.setPreferredSize(new Dimension(250, 90));

		//`pl̐ݒƒǉ
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.getViewport().add(this.panel);
		this.getContentPane().add(
			scrollPane,
			BorderLayout.CENTER);
	}

	public void initialize() {
	}

	public void terminate() {
	}

	public void prepareWorldClose(ModelContainerEvent e) {
	}

	public void prepareWorldOpen(ModelContainerEvent e) {
	}

	public void worldClosed(ModelContainerEvent e) {
		this.removeUpdateChannelListener(this);
		this.removeUpdateStepListener(this);
	}

	public void worldOpened(ModelContainerEvent e) {
		this.addUpdateChannelListener(this);
		this.addUpdateStepListener(this);
		this.panel.setPlayers(null, null);
		this.repaint();
	}

	public void goodsReceive(UpdateChannelEvent e) {
	}

	public void goodsSent(UpdateChannelEvent e) {
		Channel c = (Channel)e.getSource();
		if (c
			.getBehaviorA()
			.getType()
			.equals(
				IPDModel
					.BEHAVIORTYPE_ManageContestBehavior)
			&& c.getBehaviorB().getType().equals(
				IPDModel
					.BEHAVIORTYPE_ConductMatchBehavior)) {
			MatchInformation match =
				(MatchInformation)c
					.getBehaviorA()
					.getAgent()
					.getInformation(
						IPDModel
							.INFORMATIONTYPE_CurrentMatchInformation);
			Agent player =
				match.getEntryPair().getFirstPlayer();
			Agent opponent =
				match.getEntryPair().getLastPlayer();
			this.panel.setPlayers(player, opponent);
			this.repaint();

			System.out.println(
				this.panel.getPlayerName(player)
					+ " : "
					+ this.panel.getPlayerName(opponent));
		}
	}

	public void prepareStepStart(UpdateClockEvent e) {
		this.panel.setIsRock(false);
	}

	public void stepCompleted(UpdateClockEvent e) {
		this.panel.setIsRock(true);
	}

}

class IPDBattlePanel extends JPanel {

	private ImageIcon playerIcon;
	private ImageIcon opponentIcon;

	private Agent player;
	private Agent opponent;

	private BehaviorType playerStrategy;
	private BehaviorType opponentStrategy;

	private boolean isRock = false;

	public IPDBattlePanel() {
		super();
		Image playerImage =
			ImageProvider.getInstance().getImage(
				"org/boxed_economy/ipd/presentation/player.gif");
		this.playerIcon = new ImageIcon(playerImage);
		Image opponentImage =
			ImageProvider.getInstance().getImage(
				"org/boxed_economy/ipd/presentation/opponent.gif");
		this.opponentIcon = new ImageIcon(opponentImage);
	}

	public void paintComponent(Graphics g) {
		//`R|[lgݒ肵܂
		super.paintComponent(g);

		//EBhESʂ̐ݒ
		this.initializePanel(g);

		//vC[̕`
		this.paintCurrentBattle(g);
	}

	public void setPlayers(Agent player, Agent opponent) {
		this.player = player;
		this.opponent = opponent;
	}

	private void initializePanel(Graphics g) {
		this.setBackground(Color.white);
		g.setFont(new Font("Verdana", 0, 10));
	}

	private void paintCurrentBattle(Graphics g) {
		if (player != null) {
			BehaviorType playerStrategy =
				this.getStrategyType(this.player);
			BehaviorType opponentStrategy =
				this.getStrategyType(this.opponent);

			if (this.isRock) {
				this.playerIcon.paintIcon(this, g, 20, 20);
				g.drawString(
					this.getPlayerName(this.player),
					30,
					66);
				this.drawLineWithShadow(g, 55, 27, 68, 19);
				this.drawStringWithShadow(
					g,
					this.getStrategyName(
						this.playerStrategy),
					60,
					40);

				g.setColor(Color.RED);
				g.setFont(new Font("Verdana", 0, 11));
				g.drawString("VS", 132,42);
				g.drawString("VS", 131,42);
				g.setColor(Color.BLACK);
				g.setFont(new Font("Verdana", 0, 10));

				this.opponentIcon.paintIcon(
					this,
					g,
					200,
					20);
				g.drawString(
					this.getPlayerName(this.opponent),
					210,
					66);
				this.drawLineWithShadow(g, 155, 27, 68, 19);
				this.drawStringWithShadow(
					g,
					this.getStrategyName(
						this.opponentStrategy),
					160,
					40);
			} else {
				this.playerStrategy = playerStrategy;
				this.opponentStrategy = opponentStrategy;

				this.playerIcon.paintIcon(this, g, 20, 20);
				g.drawString(
					this.getPlayerName(this.player),
					30,
					66);
				this.drawLineWithShadow(g, 55, 27, 68, 19);
				this.drawStringWithShadow(
					g,
					this.getStrategyName(playerStrategy),
					60,
					40);
				
				g.setColor(Color.RED);
				g.setFont(new Font("Verdana", 0, 11));
				g.drawString("VS", 132,42);
				g.drawString("VS", 131,42);
				g.setColor(Color.BLACK);
				g.setFont(new Font("Verdana", 0, 10));

				this.opponentIcon.paintIcon(
					this,
					g,
					200,
					20);
				g.drawString(
					this.getPlayerName(this.opponent),
					210,
					66);
				this.drawLineWithShadow(g, 155, 27, 68, 19);
				this.drawStringWithShadow(
					g,
					this.getStrategyName(opponentStrategy),
					160,
					40);
			}

			//			System.out.println(
			//				this.getStrategyName(playerStrategy)
			//					+ ":"
			//					+ this.getStrategyName(opponentStrategy));
		}
	}

	public void setIsRock(boolean b) {
		this.isRock = b;
	}

	/*******************************
	 * ʕ`֘A
	 *******************************/

	/**
	 * etg`悵܂
	 */
	private void drawLineWithShadow(
		Graphics g,
		int x,
		int y,
		int width,
		int height) {
		g.setColor(Color.BLACK);
		g.drawRect(x, y, width, height);
		g.setColor(Color.GRAY);
		g.drawLine(
			x + width + 1,
			y + 1,
			x + width + 1,
			y + height + 1);
		g.drawLine(
			x + 1,
			y + height + 1,
			x + width,
			y + height + 1);
	}

	/**
	 * et`悵܂
	 */
	private void drawStringWithShadow(
		Graphics g,
		String s,
		int x,
		int y) {
		g.setColor(Color.LIGHT_GRAY);
		g.drawString(s, x + 2, y);
		g.setColor(Color.GRAY);
		g.drawString(s, x + 1, y);
		g.setColor(Color.BLACK);
		g.drawString(s, x, y);
	}

	/********************************
	 * O̐`֘A
	 ********************************/

	/**
	 * vC[̖OԂ܂
	 */
	public String getPlayerName(Agent player) {
		return player
			.getInformation(
				IPDModel.INFORMATIONTYPE_NameInformation)
			.toString();
	}

	/**
	 * 헪̖OԂ܂
	 */
	public String getStrategyName(BehaviorType strategy) {
		StringBuffer sb =
			new StringBuffer(strategy.getName());
		sb.delete(0, sb.lastIndexOf(".") + 1).toString();
		sb.delete(
			sb.indexOf("StrategyBehavior"),
			sb.length());
		return sb.toString();
	}

	private BehaviorType getStrategyType(Agent player) {
		return (
			(Behavior)
				(
					(List)player.getBehaviorsRecursively(
						IPDModel
							.BEHAVIORTYPE_StrategyBehavior))
							.get(
				0))
			.getType();
	}

}