/*
 * IPDScoreTableModel.java
 * Copyright (c) 2004 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.BehaviorType;

/**
 * evC[̍v_\e[û߂̃fł
 * 
 * @author tsuya
 * Create on 2004/06/15 20:33:32
 */
public class IPDPlayerTotalScoreTableModel
	extends AbstractTableModel {

	private IPDScoreViewer viewer;

	public IPDPlayerTotalScoreTableModel(IPDScoreViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * o̖OԂ܂
	 */
	public String getColumnName(int columnIndex) {
		switch (columnIndex) {
			case 0 :
				return "Player";
			case 1 :
				return "Strategy";
			case 2 :
				return "Total Score";
		}
		return null;
	}

	/**
	 * o̐Ԃ܂
	 */
	public int getColumnCount() {
		return 3;
	}

	/**
	 * s̐ivC[jԂ܂
	 */
	public int getRowCount() {
		return this
			.viewer
			.getPlayer_ScoreMap()
			.entrySet()
			.size();
	}

	/**
	 * w肳ꂽsAɕ\ׂf[^Ԃ܂
	 */
	public Object getValueAt(
		int rowIndex,
		int columnIndex) {
		List playerWithTotalScores =
			this.viewer.setSortedList(
				this.viewer.getPlayer_ScoreMap());
		ObjectWithScore o =
			(ObjectWithScore)playerWithTotalScores.get(
				rowIndex);
		switch (columnIndex) {
			//ڂPlayer
			case 0 :
				return this.viewer.getPlayerName(
					(Agent)o.getKey());
				//ڂStrategy
			case 1 :
				return this.viewer.getStrategyName(
					(BehaviorType)this
						.viewer
						.getPlayer_StrategyBehaviorTypeMap()
						.get(o.getKey()));
				//OڂTotal Score
			case 2 :
				return new Double(o.getValue());
		}
		return null;
	}

	public void update() {
		this.fireTableDataChanged();
	}

}
