/*
 * IPDScoreViewer.java
 * Copyright (c) 2004 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Information;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateChannelEvent;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateChannelListener;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateClockEvent;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateStepListener;
import org
	.boxed_economy
	.besp
	.presentation
	.guifw
	.AbstractInternalFrameComponent;
import org.boxed_economy.components.stepclock.StepClock;
import org.boxed_economy.ipd.model.IPDModel;
import org
	.boxed_economy
	.ipd
	.model
	.behavior
	.ManageContestBehavior;
import org
	.boxed_economy
	.ipd
	.model
	.information
	.MatchInformation;

/**
 * IPDf̊eG[WFg̑_\܂
 * 
 * TODO	\[XR[hYɂ悤
 * 
 * @author tsuya
 * Create on 2004/06/15 10:50:35
 */
public class IPDScoreViewer
	extends AbstractInternalFrameComponent
	implements
		ModelContainerListener,
		UpdateChannelListener,
		UpdateStepListener {

	/********************************
	 * 
	 ********************************/

	//evC[̓_L^
	private HashMap player_scoreMap;
	private HashMap previousPlayer_scoreMap;

	//evC[StepJnɂ헪L^
	private HashMap player_strategyBehaviorTypeMap;
	private HashMap previousPlayer_strategyBehaviorTypeMap;

	/********************************
	 * 
	 ********************************/

	//vC[ʑ_\ƁA헪ʕϓ__\̐؂ւ^u
	private JTabbedPane tabbedPane;

	//evC[̑_\\ƃf
	private JTable playerTotalScoreTable;
	private IPDPlayerTotalScoreTableModel playerTotalScoreModel;

	//e헪̕ϓ_\\ƃf
	private JTable strategyAverageScoreTable;
	private IPDStrategyAverageScoreTableModel strategyAverageScoreTableModel;

	//ݎ\TextField
	private JLabel stepText;
	//Jn̎iXebvŁj
	private long startStep;

	public IPDScoreViewer() {
		super();

		this.player_scoreMap = new HashMap();
		this.player_strategyBehaviorTypeMap = new HashMap();

		this.previousPlayer_scoreMap = new HashMap();
		this.previousPlayer_strategyBehaviorTypeMap =
			new HashMap();

		this.stepText = new JLabel("Step : ");
		this.startStep = 0;

		this.setTitle("IPD Score Viewer");
		this.setPreferredSize(new Dimension(600, 450));

		//Xebv\̐ݒEzu
		JPanel stepPanel = new JPanel(new GridLayout(1, 1));
		stepPanel.add(stepText);
		this.getContentPane().add(
			BorderLayout.NORTH,
			stepPanel);

		//vC[ʑ_\̐ݒ
		this.playerTotalScoreTable = new JTable();
		this
			.playerTotalScoreTable
			.createDefaultColumnsFromModel();
		this.playerTotalScoreModel =
			new IPDPlayerTotalScoreTableModel(this);
		this.playerTotalScoreTable.setModel(
			this.playerTotalScoreModel);
		JScrollPane scolledPlayerTotalScorePane =
			new JScrollPane();
		scolledPlayerTotalScorePane.getViewport().add(
			this.playerTotalScoreTable);

		//헪ʕϓ_\̐ݒ
		this.strategyAverageScoreTable = new JTable();
		this
			.strategyAverageScoreTable
			.createDefaultColumnsFromModel();
		this.strategyAverageScoreTableModel =
			new IPDStrategyAverageScoreTableModel(this);
		this.strategyAverageScoreTable.setModel(
			this.strategyAverageScoreTableModel);
		JScrollPane scolledStrategyAverageScorePane =
			new JScrollPane();
		scolledStrategyAverageScorePane.getViewport().add(
			this.strategyAverageScoreTable);

		//^u̐ݒƁAe_\̔zu
		this.tabbedPane = new JTabbedPane();
		this.getContentPane().add(
			tabbedPane,
			BorderLayout.CENTER);
		this.tabbedPane.add(
			"Player Total Score",
			scolledPlayerTotalScorePane);
		this.tabbedPane.add(
			"Strategy Average Score",
			scolledStrategyAverageScorePane);
	}

	public void worldOpened(ModelContainerEvent arg0) {
		this.addUpdateChannelListener(this);
		this.addUpdateStepListener(this);

		this.player_scoreMap.clear();
		this.player_strategyBehaviorTypeMap.clear();

		this.previousPlayer_scoreMap.clear();
		this.previousPlayer_strategyBehaviorTypeMap.clear();

		this.stepText.setText("Step : ");
		this.startStep = 0;

		//f[^ǂ݂Ƃs\ɂ
		this.canReadData = false;

		this.playerTotalScoreModel.update();
		this.strategyAverageScoreTableModel.update();
		this.repaint();
	}

	public void worldClosed(ModelContainerEvent arg0) {
		this.removeUpdateChannelListener(this);
		this.removeUpdateStepListener(this);
	}

	/**
	 * t[ɑ΂đꂽΐ팋ʂWv܂
	 */
	public void goodsReceive(UpdateChannelEvent arg0) {
		Information informationOnChannel =
			arg0.getGoods().getAttachment();
		Behavior targetBehavior = arg0.getTargetBehavior();

		//t[ɑ΂đꂽΐ팋ʂ̏ꍇAWv܂
		if (informationOnChannel
			instanceof MatchInformation
			&& targetBehavior
				instanceof ManageContestBehavior) {
			MatchInformation match =
				(MatchInformation)informationOnChannel;
			Agent firstPlayer =
				match.getEntryPair().getFirstPlayer();
			Agent lastPlayer =
				match.getEntryPair().getLastPlayer();
			int scoreOfFirstPlayer =
				match.getResultScore(firstPlayer);
			int scoreOfLastPlayer =
				match.getResultScore(lastPlayer);

			//evC[҂_𓾓_\ɉZ܂
			this.addScoreByPlayer(
				firstPlayer,
				scoreOfFirstPlayer);
			this.addScoreByPlayer(
				lastPlayer,
				scoreOfLastPlayer);

			//			System.out.println(
			//				firstPlayer + " : " + scoreOfFirstPlayer);
			//			System.out.println(
			//				lastPlayer + " : " + scoreOfLastPlayer);
		}
	}

	private boolean canReadData = false;

	/**
	 * SĂ̑ΐIAevC[̑_Ae헪̕ϓ_̕\XV܂
	 */
	public void stepCompleted(UpdateClockEvent e) {
		//		//evC[̖OA헪A_\
		//		this.playerTotalScoreModel.printRankingOfPlayers();

		//		//e헪̕ϓ_\
		//		this
		//			.strategyAverageScoreTableModel
		//			.printRankingOfStrategies();

		//f[^ǂݎ\ɂ
		this.canReadData = true;

		//\XV
		this.playerTotalScoreModel.update();
		this.strategyAverageScoreTableModel.update();
		this.repaint();

		//Xebv̕\
		this.stepEnd(e);
	}

	/**
	 * XebvJnɁAf[^SăNA܂
	 */
	public void prepareStepStart(UpdateClockEvent e) {
		//̓_\OƂĊi[
		this.previousPlayer_scoreMap = this.player_scoreMap;
		this.previousPlayer_strategyBehaviorTypeMap =
			this.player_strategyBehaviorTypeMap;

		//̓_\Ȃǂ̋L^NA
		this.player_scoreMap = new HashMap();
		this.player_strategyBehaviorTypeMap = new HashMap();

		//		this.player_scoreMap.clear();
		//		this.player_strategyBehaviorTypeMap.clear();

		this.stepBegin(e);

		//f[^ǂ݂Ƃs\ɂ
		this.canReadData = false;
	}

	/***************************
	 * Subroutine(s)
	 ***************************/

	/**
	 * P̑ΐŃvC[҂_A_\ɉZA
	 * ̃vC[̐헪L^܂
	 */
	private void addScoreByPlayer(
		Agent player,
		double earnedScore) {
		//łɒǉĂꍇA_\ɉZ
		if (this.player_scoreMap.containsKey(player)) {
			double oldScore =
				((Double)this.player_scoreMap.get(player))
					.doubleValue();
			double newScore = oldScore + earnedScore;
			this.player_scoreMap.put(
				player,
				new Double(newScore));
		}
		//܂ǉĂȂꍇA_\ǉA헪L^
		else {
			this.player_scoreMap.put(
				player,
				new Double(earnedScore));

			Behavior strategyBehavior =
				(Behavior)
					(
						(
							List)player
								.getBehaviorsRecursively(
							IPDModel
								.BEHAVIORTYPE_StrategyBehavior))
								.get(
					0);
			BehaviorType strategyType =
				strategyBehavior.getType();
			this.player_strategyBehaviorTypeMap.put(
				player,
				strategyType);
		}
	}

	/**
	 * MapvalueɏāAɃ\[gListԂ܂
	 */
	public List setSortedList(Map map) {
		List keyAndValues = new ArrayList();
		for (Iterator i = map.keySet().iterator();
			i.hasNext();
			) {
			Object key = i.next();
			double value =
				((Double)map.get(key)).doubleValue();
			keyAndValues.add(
				new ObjectWithScore(key, value));
		}
		Collections.sort(keyAndValues);
		return keyAndValues;
	}

	/********************************
	 * Xebv\֘A
	 ********************************/

	/**
	 * V~[Vs̎|\܂
	 */
	private void stepBegin(UpdateClockEvent e) {
		StepClock clock = (StepClock)e.getSource();
		if (this.startStep == 0) {
			this.startStep = clock.getStep();
			this.stepText.setText(
				"Step "
					+ Long.toString(
						clock.getStep() - startStep + 1)
					+ " is running now...");
		}else{
		this.stepText.setText(
			"Step "
				+ Long.toString(
					clock.getStep() - startStep + 2)
				+ " is running now...");
		}
	}

	/**
	 * PXebv|\܂
	 */
	private void stepEnd(UpdateClockEvent e) {
		StepClock clock = (StepClock)e.getSource();
		if (this.startStep == 0) {
			this.startStep = clock.getStep();
		}
		this.stepText.setText(
			"Step "
				+ Long.toString(
					clock.getStep() - startStep + 1)
				+ " is completed.");
	}

	/********************************
	 * O̐`֘A
	 ********************************/

	/**
	 * vC[̖OԂ܂
	 */
	public String getPlayerName(Agent player) {
		return player
			.getInformation(
				IPDModel.INFORMATIONTYPE_NameInformation)
			.toString();
	}

	/**
	 * 헪̖OԂ܂
	 */
	public String getStrategyName(BehaviorType strategy) {
		StringBuffer sb =
			new StringBuffer(strategy.getName());
		sb.delete(0, sb.lastIndexOf(".") + 1).toString();
		sb.delete(
			sb.indexOf("StrategyBehavior"),
			sb.length());
		return sb.toString();
	}

	/*************************
	 * getter(s)
	 *************************/

	public HashMap getPlayer_ScoreMap() {
		if (this.canReadData) {
			return this.player_scoreMap;
		} else {
			return this.previousPlayer_scoreMap;
		}
	}

	public HashMap getPlayer_StrategyBehaviorTypeMap() {
		if (this.canReadData) {
			return this.player_strategyBehaviorTypeMap;
		} else {
			return this
				.previousPlayer_strategyBehaviorTypeMap;
		}
	}

	/*************************
	 * Ȃ\bh
	 *************************/

	public void initialize() {
	}

	public void terminate() {
	}

	public void prepareWorldClose(ModelContainerEvent arg0) {
	}

	public void prepareWorldOpen(ModelContainerEvent arg0) {
	}

	public void goodsSent(UpdateChannelEvent arg0) {
	}

}
