/*
 * StrategyAverageScoreTableModel.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.table.AbstractTableModel;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.BehaviorType;

/**
 * @author tsuya
 * Create on 2004/06/16 1:29:13
 */
public class IPDStrategyAverageScoreTableModel
	extends AbstractTableModel {
	private IPDScoreViewer viewer;

	public IPDStrategyAverageScoreTableModel(IPDScoreViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * o̖OԂ܂
	 */
	public String getColumnName(int columnIndex) {
		switch (columnIndex) {
			case 0 :
				return "Strategy";
			case 1 :
				return "Average Score";
		}
		return null;
	}

	/**
	 * o̐Ԃ܂
	 */
	public int getColumnCount() {
		return 2;
	}

	/**
	 * s̐i헪̐jԂ܂
	 */
	public int getRowCount() {
		return this
			.createStrategy_ScoreListMap()
			.entrySet()
			.size();
	}

	/**
	 * w肳ꂽsAɕ\ׂf[^Ԃ܂
	 */
	public Object getValueAt(
		int rowIndex,
		int columnIndex) {

		//e헪̍v_vZ܂
		Map strategyBehaviorType_scoreListMap =
			this.createStrategy_ScoreListMap();

		//ϓ_vZ
		Map strategyBehaviorType_averageScoreMap =
			this.createStrategy_AverageScoreMap(
				strategyBehaviorType_scoreListMap);

		List strategyWithAverageScores =
			this.viewer.setSortedList(
				strategyBehaviorType_averageScoreMap);

		ObjectWithScore o =
			(ObjectWithScore)strategyWithAverageScores.get(
				rowIndex);
		switch (columnIndex) {
			//ڂStrategy
			case 0 :
				return this.viewer.getStrategyName(
					(BehaviorType)o.getKey());
				//ڂAverage Score
			case 1 :
				return new Double(o.getValue());
		}
		return null;
	}

	public void update() {
		this.fireTableDataChanged();
	}

	/**
	 * e헪Ƃ̑_߂ꂽMapԂ܂
	 */
	private Map createStrategy_ScoreListMap() {
		HashMap strategyBehaviorType_scoreListMap =
			new HashMap();
		for (Iterator i =
			this
				.viewer
				.getPlayer_ScoreMap()
				.keySet()
				.iterator();
			i.hasNext();
			) {
			Agent player = (Agent)i.next();
			BehaviorType strategyBehaviorType =
				(BehaviorType)this
					.viewer
					.getPlayer_StrategyBehaviorTypeMap()
					.get(player);
			if (strategyBehaviorType_scoreListMap
				.containsKey(strategyBehaviorType)) {
				List scores =
					(
						List)strategyBehaviorType_scoreListMap
							.get(
						strategyBehaviorType);
				scores.add(
					new Double(
						((Double)this
							.viewer
							.getPlayer_ScoreMap()
							.get(player))
							.doubleValue()));
			} else {
				List scores = new ArrayList();
				scores.add(
					new Double(
						((Double)this
							.viewer
							.getPlayer_ScoreMap()
							.get(player))
							.doubleValue()));
				strategyBehaviorType_scoreListMap.put(
					strategyBehaviorType,
					scores);
			}
		}
		return strategyBehaviorType_scoreListMap;
	}

	/**
	 * 헪Ƃ̕ϓ_߂ꂽMapԂ܂
	 */
	private Map createStrategy_AverageScoreMap(Map strategyBehaviorType_scoreListMap) {
		HashMap strategyBehaviorType_averageScoreMap =
			new HashMap();
		for (Iterator i =
			strategyBehaviorType_scoreListMap
				.keySet()
				.iterator();
			i.hasNext();
			) {
			BehaviorType strategyBehaviorType =
				(BehaviorType)i.next();
			List scores =
				(
					List)strategyBehaviorType_scoreListMap
						.get(
					strategyBehaviorType);
			double totalScore = 0.0;
			int size = scores.size();
			while (!scores.isEmpty()) {
				double score =
					((Double)scores.remove(0))
						.doubleValue();
				totalScore = totalScore + score;
			}
			double averageScore = totalScore / size;
			strategyBehaviorType_averageScoreMap.put(
				strategyBehaviorType,
				new Double(averageScore));
		}
		return strategyBehaviorType_averageScoreMap;
	}

}
