/*
 * IPDStrategyEvolutionPanel.java
 * Copyright (c) 2004 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JPanel;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.ipd.model.IPDModel;

/**
 * evC[̐헪̕ϑJ`悳plł
 * 
 * @author tsuya
 * Create on 2004/06/16 18:14:08
 */
public class IPDStrategyEvolutionPanel extends JPanel {

	private IPDStrategyEvolutionViewer viewer;
	private ImageIcon playerIcon;
	private ImageIcon arrowIcon;
	private ImageIcon roseIcon;

	public IPDStrategyEvolutionPanel(IPDStrategyEvolutionViewer viewer) {
		super();
		this.viewer = viewer;

		Image playerImage =
			ImageProvider.getInstance().getImage(
				"org/boxed_economy/ipd/presentation/player.gif");
		this.playerIcon = new ImageIcon(playerImage);
		Image arrowImage =
			ImageProvider.getInstance().getImage(
				"org/boxed_economy/ipd/presentation/arrow.gif");
		this.arrowIcon = new ImageIcon(arrowImage);
		Image roseImage =
			ImageProvider.getInstance().getImage(
				"org/boxed_economy/ipd/presentation/rose.gif");
		this.roseIcon = new ImageIcon(roseImage);
	}

	public void paintComponent(Graphics g) {
		//`R|[lgݒ肵܂
		super.paintComponent(g);

		this.initializePanel(g);
		this.paintCurrentSituation(g);
	}

	/***************************
	 * Subroutine(s)
	 ***************************/

	/**
	 * pl̏ݒs܂
	 */
	private void initializePanel(Graphics g) {
		this.setBackground(Color.white);
		g.setFont(new Font("Verdana", 0, 10));
	}

	private static final int heightBetweenPlayer = 120;
	private static final int widthBetweenStrategy = 120;

	/**
	 * ݂̏󋵂`悵܂
	 */
	private void paintCurrentSituation(Graphics g) {
		HashMap player_selectedStrategyListMap =
			this.viewer.getPlayer_selectedStrategyListMap();
		HashMap player_strategyCandidateListMap =
			this
				.viewer
				.getPlayer_strategyCandidateListMap();

		//evC[̏Ԃ`
		int playerIndex = 0;
		int changeSize = 0;
		for (Iterator i =
			player_selectedStrategyListMap
				.keySet()
				.iterator();
			i.hasNext();
			) {
			Agent player = (Agent)i.next();

			//vC[̏ԁiACRAOAŏ̐헪j`
			drawPlayerBeginningSituation(
				g,
				player_selectedStrategyListMap,
				playerIndex,
				player);

			//vC[̐헪̌⃊XgA`
			List candidatesList =
				(List)player_strategyCandidateListMap.get(
					player);
			if (candidatesList != null) {
				changeSize = candidatesList.size();
				for (int changeIndex = 0;
					changeIndex < changeSize;
					changeIndex++) {
					drawArrowAndStrategyCandidates(
						g,
						player_selectedStrategyListMap,
						player_strategyCandidateListMap,
						playerIndex,
						changeIndex,
						player);
				}
			}

			playerIndex++;
		}

		//pl̃TCY
		int panelWidth =
			changeSize * widthBetweenStrategy + 100;
		int panelHeight =
			playerIndex * heightBetweenPlayer + 30;
		this.setPreferredSize(
			new Dimension(panelWidth, panelHeight));
	}

	/*******************************
	 * vC[`֘A
	 *******************************/

	/**
	 * vC[̏ԁiACRAOAŏ̐헪j`悵܂
	 */
	private void drawPlayerBeginningSituation(
		Graphics g,
		HashMap player_selectedStrategyListMap,
		int playerIndex,
		Agent player) {
		List strategyList =
			(List)player_selectedStrategyListMap.get(
				player);
		BehaviorType strategyType =
			(BehaviorType)strategyList.get(0);

		//vC[ACR
		this.playerIcon.paintIcon(
			this,
			g,
			10,
			10 + playerIndex * heightBetweenPlayer);

		//vC[
		g.setColor(Color.BLACK);
		g.drawString(
			this.getPlayerName(player),
			20,
			56 + playerIndex * heightBetweenPlayer);

		//Ă헪
		this.drawLineWithShadow(g,45,17 + playerIndex * heightBetweenPlayer,68,19);
		this.drawStringWithShadow(
			g,
			this.getStrategyName(strategyType),
			50,
			30 + playerIndex * heightBetweenPlayer);
	}

	/**
	 * Ił헪⃊XgƖ`悵܂
	 */
	private void drawArrowAndStrategyCandidates(
		Graphics g,
		HashMap player_selectedStrategyListMap,
		HashMap player_strategyCandidateListMap,
		int playerIndex,
		int changeIndex,
		Agent player) {

		//
		this.arrowIcon.paintIcon(
			this,
			g,
			120 + changeIndex * widthBetweenStrategy,
			18 + playerIndex * heightBetweenPlayer);

		//ۂɑI΂ꂽ헪ƁA헪̌⃊Xg̕`
		List strategyCandidatesList =
			(List)player_strategyCandidateListMap.get(
				player);
		if (strategyCandidatesList != null) {

			//ۂɑI΂ꂽ헪
			List selectedStrategys =
				(List)player_selectedStrategyListMap.get(
					player);
			BehaviorType selectedStrategy =
				(BehaviorType)selectedStrategys.get(
					changeIndex + 1);
			//+1ȂƕύXO̐헪ɓ

			HashMap strategyCandidates =
				(HashMap)strategyCandidatesList.get(
					changeIndex);

			//ۂɑI΂ꂽ헪̕`
			this.drawStringWithShadow(
				g,
				this.getStrategyName(selectedStrategy),
				170 + changeIndex * widthBetweenStrategy,
				30 + playerIndex * heightBetweenPlayer);

			//헪QɑI΂Ă̂Ăremove
			if (strategyCandidates
				.containsKey(selectedStrategy)) {
				strategyCandidates.remove(selectedStrategy);
			}

			//I΂Ȃ헪Q̕`
			g.setColor(Color.DARK_GRAY);
			int candidateIndex = 1;
			for (Iterator j =
				strategyCandidates.keySet().iterator();
				j.hasNext();
				) {
				BehaviorType candidateType =
					(BehaviorType)j.next();
				g.drawString(
					this.getStrategyName(candidateType),
					170
						+ changeIndex * widthBetweenStrategy,
					30
						+ playerIndex * heightBetweenPlayer
						+ candidateIndex * 10);
				candidateIndex++;
			}

			//g̕`
			this.drawLineWithShadow(
				g,
				164 + changeIndex * widthBetweenStrategy,
				17 + playerIndex * heightBetweenPlayer,
				67,
				10 + 10 * candidateIndex);

			//Ԃ̕`
			this.roseIcon.paintIcon(
				this,
				g,
				160 + changeIndex * widthBetweenStrategy,
				22 + playerIndex * heightBetweenPlayer);
		}
	}

	/*******************************
	 * ʕ`֘A
	 *******************************/

	/**
	 * etg`悵܂
	 */
	private void drawLineWithShadow(
		Graphics g,
		int x,
		int y,
		int width,
		int height) {
		g.setColor(Color.BLACK);
		g.drawRect(x, y, width, height);
		g.setColor(Color.GRAY);
		g.drawLine(
			x + width + 1,
			y + 1,
			x + width + 1,
			y + height + 1);
		g.drawLine(
			x + 1,
			y + height + 1,
			x + width,
			y + height + 1);
	}

	/**
	 * et`悵܂
	 */
	private void drawStringWithShadow(
		Graphics g,
		String s,
		int x,
		int y) {
		g.setColor(Color.LIGHT_GRAY);
		g.drawString(s, x + 2, y);
		g.setColor(Color.GRAY);
		g.drawString(s, x + 1, y);
		g.setColor(Color.BLACK);
		g.drawString(s, x, y);
	}

	/********************************
	 * O̐`֘A
	 ********************************/

	/**
	 * vC[̖OԂ܂
	 */
	public String getPlayerName(Agent player) {
		return player
			.getInformation(
				IPDModel.INFORMATIONTYPE_NameInformation)
			.toString();
	}

	/**
	 * 헪̖OԂ܂
	 */
	public String getStrategyName(BehaviorType strategy) {
		StringBuffer sb =
			new StringBuffer(strategy.getName());
		sb.delete(0, sb.lastIndexOf(".") + 1).toString();
		sb.delete(
			sb.indexOf("StrategyBehavior"),
			sb.length());
		return sb.toString();
	}

}
