/*
 * IPDStrategyEvolutionViewer.java
 * Copyright (c) 2004 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JScrollPane;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.World;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateChannelEvent;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateChannelListener;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateClockEvent;
import org
	.boxed_economy
	.besp
	.model
	.fmfw
	.update
	.UpdateStepListener;
import org
	.boxed_economy
	.besp
	.presentation
	.guifw
	.AbstractInternalFrameComponent;
import org.boxed_economy.ipd.model.IPDModel;
import org
	.boxed_economy
	.ipd
	.model
	.information
	.ContestInformation;

/**
 * evC[̐헪̐i\܂
 * 	- ۂɑI΂ꂽ헪L^
 * 	- 헪̌QL^
 * 
 * @author tsuya
 * Create on 2004/06/15 19:39:27
 */
public class IPDStrategyEvolutionViewer
	extends AbstractInternalFrameComponent
	implements
		ModelContainerListener,
		UpdateStepListener,
		UpdateChannelListener {

	/****************************
	 * f[^i[֘ÃtB[h
	 ****************************/

	//Viewer\World
	private World ipdWorld;

	//ۂɑIꂽ헪nɊi[ꂽXg
	private HashMap player_selectedStrategyList_Map =
		new HashMap();
	//I헪̌⃊XgnɊi[ꂽXg
	private HashMap player_strategyCandidateList_Map =
		new HashMap();

	/****************************
	 * GUI֘ÃtB[h
	 ****************************/

	//헪̕ϑJ`悳pl
	private IPDStrategyEvolutionPanel panel;
	//vC[̃ACR
	private ImageIcon playerIcon;

	/**
	 * Constructor
	 */
	public IPDStrategyEvolutionViewer() {
		super();
		this.setTitle("IPD Strategy Evolution Viewer");
		this.setSize(new Dimension(400, 400));

		this.panel = new IPDStrategyEvolutionPanel(this);
		this.panel.setPreferredSize(
			new Dimension(1600, 1600));

		//`pl̐ݒƒǉ
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.getViewport().add(this.panel);

		this.getContentPane().add(
			scrollPane,
			BorderLayout.CENTER);
	}

	/**
	 * fJꂽƂɁAWorldƁAevC[̏̐헪L^܂
	 */
	public void worldOpened(ModelContainerEvent e) {
		this.addUpdateChannelListener(this);
		this.addUpdateStepListener(this);

		this.player_selectedStrategyList_Map.clear();
		this.player_strategyCandidateList_Map.clear();

		//World̎擾
		this.ipdWorld = e.getWorld();

		//evC[̑IĂ헪L^
		this.recordSelectedStrategyByEachAgent();

		this.repaint();
	}

	public void worldClosed(ModelContainerEvent arg0) {
		this.removeUpdateChannelListener(this);
		this.removeUpdateStepListener(this);
	}

	/**
	 * vC[ΐ팋ʂ󂯂ƂɁAIׂ헪̌⃊XgL^܂
	 */
	public void goodsReceive(UpdateChannelEvent e) {
		if (e
			.getGoods()
			.hasInformation(
				IPDModel
					.INFORMATIONTYPE_ContestResultInformation)) {
			Agent player = e.getTargetBehavior().getAgent();
			ContestInformation contestResult =
				(ContestInformation)e
					.getGoods()
					.getInformation(
					IPDModel
						.INFORMATIONTYPE_ContestResultInformation);

			//Iׂ헪̌⃊Xg̋L^
			this.recordStrategyCandidateList(
				player,
				contestResult);
		}
	}

	/**
	 * XebvIɁAevC[I񂾐헪L^Aĕ`悵܂
	 */
	public void stepCompleted(UpdateClockEvent e) {

		//evC[I񂾐헪L^
		this.recordSelectedStrategyByEachAgent();

		//EBhE̍ĕ`
		this.repaint();
	}

	/***************************
	 * Subroutine(s)
	 ***************************/

	/**
	 * evC[ݑIĂ헪L^܂
	 */
	private void recordSelectedStrategyByEachAgent() {
		Collection players =
			this.ipdWorld.getAgents(
				IPDModel.AGENTTYPE_PlayerAgent);
		for (Iterator i = players.iterator();
			i.hasNext();
			) {
			Agent player = (Agent)i.next();
			BehaviorType strategyType =
				this.getStrategyType(player);

			//			System.out.println(
			//				this.toStringWithFairing(player.toString())
			//					+ " "
			//					+ this.toStringWithFairing(
			//						strategyType.getName()));

			if (this
				.player_selectedStrategyList_Map
				.containsKey(player)) {
				//vC[ƁAvC[̍I񂾐헪L^
				List strategies =
					(
						List)this
							.player_selectedStrategyList_Map
							.get(
						player);
				strategies.add(strategyType);
			} else {
				//ListāAIĂ헪i[
				List strategies = new ArrayList();
				strategies.add(strategyType);
				this.player_selectedStrategyList_Map.put(
					player,
					strategies);
			}
		}
	}

	/**
	 * evC[Ił헪̌⃊XgL^܂
	 */
	private void recordStrategyCandidateList(
		Agent player,
		ContestInformation contestResult) {

		//TODO ǓIȂ̂ƁAߎIȂ̂̎؂ւ
		Behavior changeStrategy =
			(Behavior)
				(
					(List)player.getBehaviorsRecursively(
						IPDModel
							.BEHAVIORTYPE_ChangeStrategyBehavior))
							.get(
				0);
		BehaviorType changeType = changeStrategy.getType();

		List winners = new ArrayList();
		//ǓIȐ؂ւ
		if (changeType
			.equals(
				IPDModel
					.BEHAVIORTYPE_ChangeStrategyWithHighScorePlayersBehavior)) {
			winners =
				contestResult
					.getHighScorePlayers(player)
					.getWinners();

			//			System.out.println("ǓI");
		}
		//ߎIȐ؂ւ
		else if (
			changeType.equals(
				IPDModel
					.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior)) {
			winners =
				contestResult
					.getStrongerPlayers(player)
					.getWinners();

			//			System.out.println("ߎI");
		}

		//		System.out.println(
		//			this.toStringWithFairing(player.toString()));

		//́AI\Ȑ헪⃊Xg̍쐬
		HashMap strategyCandidates = new HashMap();
		for (Iterator j = winners.iterator();
			j.hasNext();
			) {
			Agent winner = (Agent)j.next();
			BehaviorType winnerStrategyType =
				((Behavior) ((List)winner
					.getBehaviorsRecursively(
						IPDModel
							.BEHAVIORTYPE_StrategyBehavior))
					.get(0))
					.getType();
			strategyCandidates.put(
				winnerStrategyType,
				winnerStrategyType);

			//			System.out.println(
			//				" "
			//					+ this.toStringWithFairing(
			//						winnerStrategyType.getName()));
		}

		//쐬Xgǉ
		if (this
			.player_strategyCandidateList_Map
			.containsKey(player)) {
			List candidateslists =
				(
					List)this
						.player_strategyCandidateList_Map
						.get(
					player);
			candidateslists.add(strategyCandidates);
		} else {
			List candidateslists = new ArrayList();
			candidateslists.add(strategyCandidates);
			this.player_strategyCandidateList_Map.put(
				player,
				candidateslists);
		}
	}

	/**
	 * vC[̂헪̎ނԂ܂
	 */
	private BehaviorType getStrategyType(Agent player) {
		Behavior strategyBehavior =
			(Behavior)
				(
					(List)player.getBehaviorsRecursively(
						IPDModel
							.BEHAVIORTYPE_StrategyBehavior))
							.get(
				0);
		return strategyBehavior.getType();
	}

	/**
	 * org.boxed_economy...ƂȂԂ܂
	 */
	public String toStringWithFairing(String value) {
		StringBuffer sb = new StringBuffer(value);
		return sb
			.delete(0, value.lastIndexOf(".") + 1)
			.toString();
	}

	/************************
	 * getter
	 ************************/

	public HashMap getPlayer_selectedStrategyListMap() {
		return this.player_selectedStrategyList_Map;
	}

	public HashMap getPlayer_strategyCandidateListMap() {
		return this.player_strategyCandidateList_Map;
	}

	/************************
	 * Ȃ\bh
	 ************************/

	public void initialize() {
	}

	public void terminate() {
	}

	public void prepareWorldOpen(ModelContainerEvent arg0) {
	}

	public void prepareWorldClose(ModelContainerEvent arg0) {
	}

	public void prepareStepStart(UpdateClockEvent arg0) {
	}

	public void goodsSent(UpdateChannelEvent arg0) {
	}

}
