/*
 * IPDViewerPlugin.java
 * Copyright (c) 2004 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.presentation.bface.menu.Menu;
import org
	.boxed_economy
	.besp
	.presentation
	.guifw
	.CreateComponentAction;

/**
 * @author tsuya
 * Create on 2004/06/15 10:30:08
 */
public class IPDViewerPlugin implements BESPPlugin {

	public static void initializePlugin(BESPContainer container) {

		//Add Show Group
		Menu group = new Menu("IPD Viewer");
		container
			.getPresentationContainer()
			.addMenuElementToShowMenu(group);

		//Add Show Action
		CreateComponentAction showIPDScoreViewerAction =
			new CreateComponentAction(
				"IPD Score Viewer",
				IPDScoreViewer.class);
		group.add(showIPDScoreViewerAction);

		CreateComponentAction showIPDStrategyEvolutionViewerAction =
			new CreateComponentAction(
				"IPD Strategy Evolution Viewer",
				IPDStrategyEvolutionViewer.class);
		group.add(showIPDStrategyEvolutionViewerAction);

		CreateComponentAction showIPDBattleViewerAction =
			new CreateComponentAction(
				"IPD Battle Viewer",
				IPDBattleViewer.class);
		group.add(showIPDBattleViewerAction);
	}

}
