/*
 * ImageProvider.java
 * Created on 2003/10/15
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JPanel;

/**
 * Class ImageProvider.
 * 
 * @author macchan
 * @version $Id: ImageProvider.java,v 1.1 2004/06/16 13:16:19 tsuya Exp $
 */
public class ImageProvider {

	private static ImageProvider instance;

	public static final ImageProvider getInstance() {
		if (instance == null) {
			instance = new ImageProvider();
		}
		return instance;
	}

	private Map imageTable = new HashMap();

	/**
	 * Constructor for ImageProvider.
	 */
	private ImageProvider() {
		super();
	}

	public Image getImage(String name) {
		return getImage(
			name,
			ClassLoader.getSystemClassLoader());
	}

	private Image getImage(
		String name,
		ClassLoader classLoader) {
		if (!imageTable.containsKey(name)) {
			try {
				URL url =
					createResourceURL(name, classLoader);
				Image image = loadImage(url);
				imageTable.put(name, image);
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
		return (Image)imageTable.get(name);
	}

	private URL createResourceURL(
		String name,
		ClassLoader classLoader) {
		URL url = classLoader.getResource(name);
		if (url == null) {
			throw new RuntimeException(
				"Invalid resource name in createResourceURL() name="
					+ name);
		}
		return url;
	}

	private Image loadImage(URL url) throws Exception {
		Image image =
			Toolkit.getDefaultToolkit().getImage(url);
		MediaTracker mt = new MediaTracker(new JPanel());
		mt.addImage(image, 0);
		mt.waitForAll();
		return image;
	}

}
