/**
 * TestWorldViewer.java
 * Copyright (c) 2002 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.ipd.presentation;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.World;

/**
 * @author Administrator
 * @version $Id: TestWorldViewer.java,v 1.1 2004/06/15 13:10:38 bam Exp $
 */
public class TestWorldViewer {

	/**
	 * Worldɑ݂SĂAgent̏Ԃo͂܂
	 */
	public void printWorldCondition(World world) {
		if (world.getAllAgents().isEmpty()) {
			System.out.println("No agent : " + world);
		} else {
			System.out.println("AgentList");

			//AgentЂƂ肸o͂܂
			for (Iterator i = world.getAllAgents().iterator(); i.hasNext();) {
				Agent agent = (Agent) i.next();
				System.out.println(
					"	|- "
						+ agent.getType().getName()
						+ " (="
						+ agent
						+ ")");
				this.printHoldingGoodsCondition(agent);
				this.printHoldingInformationCondition(agent);
				this.printHoldingRelationCondition(agent);
			}
		}
	}

	/**
	 * Agent̂SĂGoods̎ށEʂo͂܂
	 */
	private void printHoldingGoodsCondition(Agent agent) {
		System.out.println("	|	|- GoodsManager");
		if (agent.getGoodsTypes().isEmpty()) {
			System.out.println("	|	|	|- (No Goods)");
		} else {
			for (Iterator i = agent.getGoodsTypes().iterator(); i.hasNext();) {
				GoodsType goodsType = (GoodsType) i.next();
				System.out.println(
					"	|	|	|- "
						+ goodsType.getName()
						+ " ["
						+ agent.getQuantity(goodsType).getValueAsDouble()
						+ "]");
			}
		}
		System.out.println("	|	|");
	}

	/**
	 * Agent̂SĂInformation̎ނo͂܂
	 * (TO DO : BeanReflectionŃtB[hƂĂ悤ɂ邱)
	 */
	private void printHoldingInformationCondition(Agent agent) {
		System.out.println("	|	|- InformationManager");
		try {
			if (agent.getInformations().values().isEmpty()) {
				System.out.println("	|	|	|- (No Information)");
			} else {
				for (Iterator i = agent.getInformations().values().iterator();
					i.hasNext();
					) {
					Information information = (Information) i.next();

					//o͂InformatioñNX̐`
					String informationTypeToString =
						agent
							.getWorld()
							.getInformationType(information)
							.getName();
					Pattern pattern =
						Pattern.compile(
							Class
								.forName(informationTypeToString)
								.getPackage()
								.getName()
								+ ".");
					Matcher matcher = pattern.matcher(informationTypeToString);
					informationTypeToString = matcher.replaceFirst("");
					System.out.println(
						"	|	|	|- "
							+ informationTypeToString
							+ " (="
							+ information
							+ ")");
				}
			}
			System.out.println("	|	|");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void printHoldingRelationCondition(Agent agent) {
		System.out.println("	|	|- RelationManager");
		if (agent.getRelationTypes().isEmpty()) {
			System.out.println("	|	|	|- (No Relation)");
		} else {
			for (Iterator i = agent.getRelationTypes().iterator();
				i.hasNext();
				) {
				RelationType relationType = (RelationType) i.next();
				System.out.println(
					"	|	|	|- " + relationType.getName());
				for (Iterator j = agent.getRelations(relationType).iterator();
					j.hasNext();
					) {
					Relation relation = (Relation) j.next();
					System.out.println(
						"	|	|	|	|- >> "
							+ relation.getTarget().getType().getName()
							+ " (="
							+ relation.getTarget()
							+ ")");
					System.out.println("	|	|	|");
				}
			}
		}
		System.out.println("	|");
	}

}

