/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.io.filesystem;

public class FileName {
    public static final String EXTENSION_DELIMITER = ".";
    private String name;

    public FileName(String name) {
        this.name = name;
    }

    public FileName(String nameOfBody, String extension) {
        this.name = String.valueOf(nameOfBody) + EXTENSION_DELIMITER + extension;
    }

    public String getName() {
        return this.name;
    }

    public String getNameOfBody() {
        int delimiterIndex = this.name.lastIndexOf(EXTENSION_DELIMITER);
        if (delimiterIndex > 0) {
            return this.name.substring(0, delimiterIndex);
        }
        return this.name;
    }

    public String getExtension() {
        int delimiterIndex = this.name.lastIndexOf(EXTENSION_DELIMITER);
        if (delimiterIndex > 0) {
            return this.name.substring(delimiterIndex + 1);
        }
        return "";
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (another instanceof FileName) {
            return this.name.equals(((FileName)another).name);
        }
        return false;
    }

    public static void main(String[] args) {
        FileName.test("hoge.svg");
        FileName.test("hoge.svg.svg");
        FileName.test("hoge.");
        FileName.test(".svg");
        FileName.test(".svg.svg");
    }

    static void test(String filename) {
        FileName fileName = new FileName(filename);
        System.out.println("Test Of " + filename);
        System.out.println("FullName: " + fileName.getName());
        System.out.println("Body: " + fileName.getNameOfBody());
        System.out.println("Extension: " + fileName.getExtension());
        System.out.println();
    }
}

