/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.io.xml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ElementReader {
    private Element element;
    private Element currentChild;

    ElementReader(Element element) {
        this.element = element;
        this.initialize();
    }

    private void initialize() {
        if (this.element != null) {
            this.toNextChild();
        }
    }

    public boolean hasCurrentChild() {
        return this.currentChild != null;
    }

    public void toNextChild() {
        Node nextNode;
        for (nextNode = this.currentChild == null ? this.element.getFirstChild() : this.currentChild.getNextSibling(); nextNode != null && (!(nextNode instanceof Element) || ((Element)nextNode).hasAttribute("_name")); nextNode = nextNode.getNextSibling()) {
        }
        this.currentChild = (Element)nextNode;
    }

    public Element getCurrentChild() {
        return this.currentChild;
    }

    public Element getChild(String name) {
        NodeList nodes = this.element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element child;
            Node node = nodes.item(i);
            if (node instanceof Element && name.equals((child = (Element)node).getAttribute("_name"))) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public boolean hasChild(String name) {
        return this.getChild(name) != null;
    }

    public Element getElement() {
        return this.element;
    }

    public int getElementCount() {
        int count = 0;
        NodeList nodes = this.element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

