/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.io.xml;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import jp.ac.keio.sfc.crew.io.xml.ElementReader;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectConstants;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectIDMapper;
import jp.ac.keio.sfc.crew.io.xml.XMLSerializable;
import jp.ac.keio.sfc.crew.refrection.ArrayObject;
import jp.ac.keio.sfc.crew.refrection.ClassObject;
import jp.ac.keio.sfc.crew.refrection.FieldObject;
import jp.ac.keio.sfc.crew.refrection.ObjectObject;
import jp.ac.keio.sfc.crew.refrection.PrimitiveObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLObjectInputStream
extends ObjectInputStream
implements XMLObjectConstants {
    private Document document;
    private Stack elementStack = new Stack();
    private Stack objectStack = new Stack();
    private XMLObjectIDMapper idMap = new XMLObjectIDMapper();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public XMLObjectInputStream(Document document) throws IOException {
        this.document = document;
    }

    private void pushElement(Element element) {
        this.elementStack.push(new ElementReader(element));
    }

    private Element popElement() {
        return ((ElementReader)this.elementStack.pop()).getElement();
    }

    public Element getCurrentElement() {
        return ((ElementReader)this.elementStack.peek()).getElement();
    }

    private ElementReader getCurrentElementReader() {
        return (ElementReader)this.elementStack.peek();
    }

    private void pushObject(Object object) {
        this.objectStack.push(object);
    }

    private Object popObject() {
        return this.objectStack.pop();
    }

    private Object getCurrentObject() {
        return this.objectStack.peek();
    }

    private Element getCurrentChild() {
        return this.getCurrentElementReader().getCurrentChild();
    }

    private boolean hasChild(String name) {
        return this.getChild(name) != null;
    }

    private Element getChild(String name) {
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        ElementReader reader = this.getCurrentElementReader();
        return reader.getChild(name);
    }

    public String getAttribute(String key) {
        String value = this.getCurrentElement().getAttribute(key);
        if (value.indexOf("&cr;") != -1) {
            value = value.replaceAll("&cr;", "\n");
        }
        return value;
    }

    public String getChildAttribute(String key) {
        return this.getCurrentElement().getAttribute(key);
    }

    public boolean hasAttribute(String name) {
        return this.getCurrentElement().hasAttribute(name);
    }

    public void startReadChildElement() {
        if (this.elementStack.isEmpty()) {
            this.pushElement(this.document.getDocumentElement());
        } else {
            ElementReader reader = this.getCurrentElementReader();
            this.pushElement(this.getCurrentChild());
            reader.toNextChild();
        }
    }

    public void startReadElement(Element tag) {
        this.pushElement(tag);
    }

    public void finishReadElement() {
        this.popElement();
    }

    public void putObjectID(Object object, String id) {
        if (object == null || id == null) {
            return;
        }
        this.idMap.putObject(object, id);
    }

    public Object getObject(String id) {
        return this.idMap.getObject(id);
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        this.startReadChildElement();
        Object object = this.readObjectImpl();
        this.finishReadElement();
        return object;
    }

    private Object readObject(Element element) throws IOException, ClassNotFoundException {
        this.startReadElement(element);
        Object object = this.readObjectImpl();
        this.finishReadElement();
        return object;
    }

    private Object readObjectImpl() throws IOException, ClassNotFoundException {
        if (this.isNullObject()) {
            return null;
        }
        if (this.isPrimitive()) {
            return this.readObjectAsPrimitive();
        }
        if (this.isArray()) {
            return this.readObjectAsArray();
        }
        if (this.isReference()) {
            return this.readObjectAsReference();
        }
        if (this.isCollection()) {
            return this.readObjectAsObject();
        }
        if (this.isMap()) {
            return this.readObjectAsObject();
        }
        if (this.isObject()) {
            return this.readObjectAsObject();
        }
        throw new RuntimeException("Illegal Tag Name");
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        ObjectObject objectwrapper = new ObjectObject(this.getCurrentObject());
        List fields = objectwrapper.getAllFields();
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            FieldObject field = (FieldObject)i.next();
            if (ClassObject.lookup(field.getType()).isPrimitive()) {
                if (!this.hasAttribute(field.getName())) continue;
                String value = this.getAttribute(field.getName());
                PrimitiveObject wrapperValue = PrimitiveObject.createObject(field.getType());
                wrapperValue.setValueFromString(value);
                field.setValue(wrapperValue.getValue());
                continue;
            }
            if (!this.hasChild(field.getName())) continue;
            Element child = this.getChild(field.getName());
            Object object = this.readObject(child);
            field.setValue(object);
        }
    }

    private Object readObjectAsReference() throws IOException, ClassNotFoundException {
        String id = this.getCurrentElement().getAttribute("idref");
        Object object = this.idMap.getObject(id);
        if (object == null) {
            return this.resolveReference(id);
        }
        return object;
    }

    private Object resolveReference(String id) throws IOException, ClassNotFoundException {
        Element element = this.searchElement(id);
        if (element == null) {
            System.err.println("XMLObjectInputStream: Unresolved Reference id=" + id);
            return null;
        }
        return this.readObject(element);
    }

    private Element searchElement(String id) {
        Element parent = this.document.getDocumentElement();
        return this.searchElement(parent, id);
    }

    private Element searchElement(Element current, String id) {
        if (current.hasAttribute("_id") && current.getAttribute("_id").equals(id)) {
            return current;
        }
        NodeList nodes = current.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element element;
            Element result;
            if (nodes.item(i) instanceof Element && (result = this.searchElement(element = (Element)nodes.item(i), id)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private Object readObjectAsObject() throws IOException, ClassNotFoundException {
        String clazz = this.getCurrentElement().getAttribute("_class");
        String id = this.getCurrentElement().getAttribute("_id");
        Object object = this.idMap.getObject(id);
        if (object != null) {
            return object;
        }
        ObjectObject objectWrapper = (ObjectObject)ClassObject.forName(clazz).newInstance();
        this.idMap.putObject(objectWrapper.getValue(), id);
        this.pushObject(objectWrapper.getValue());
        if (this.isCollection()) {
            this.readObjectAsCollection();
        } else if (this.isMap()) {
            this.readObjectAsMap();
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.io.ObjectInputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (objectWrapper.hasMethod("readObject", clazz2)) {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("java.io.ObjectInputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                objectWrapper.invokeMethod("readObject", clazz3, this);
            } else if (objectWrapper.getValue() instanceof XMLSerializable) {
                ((XMLSerializable)objectWrapper.getValue()).readObject(this);
            } else {
                this.defaultReadObject();
            }
        }
        this.popObject();
        return objectWrapper.getValue();
    }

    private Object readObjectAsPrimitive() {
        String type = this.getCurrentElement().getAttribute("_class");
        String value = this.getCurrentElement().getAttribute("value");
        ClassObject childClass = ClassObject.forName(type);
        PrimitiveObject primitiveValue = (PrimitiveObject)childClass.newInstance();
        primitiveValue.setValueFromString(value);
        return primitiveValue.getValue();
    }

    private Object readObjectAsArray() throws IOException, ClassNotFoundException {
        int size = Integer.parseInt(this.getCurrentElement().getAttribute("size"));
        String type = this.getCurrentElement().getAttribute("_class");
        ClassObject clazz = ClassObject.forName(type);
        ArrayObject array = ArrayObject.createObject(clazz, size);
        int i = 0;
        while (i < size) {
            Object object = this.readObject();
            array.set(i, object);
            ++i;
        }
        return array.getValue();
    }

    private Object readObjectAsCollection() throws IOException, ClassNotFoundException {
        Collection collection = (Collection)this.getCurrentObject();
        int size = this.getCurrentElementReader().getElementCount();
        int i = 0;
        while (i < size) {
            Object element = this.readObject();
            collection.add(element);
            ++i;
        }
        return collection;
    }

    private Object readObjectAsMap() throws IOException, ClassNotFoundException {
        Map map = (Map)this.getCurrentObject();
        int size = this.getCurrentElementReader().getElementCount() / 2;
        int i = 0;
        while (i < size) {
            Object key = this.readObject();
            Object value = this.readObject();
            map.put(key, value);
            ++i;
        }
        return map;
    }

    private boolean isReference() {
        return this.getCurrentElement().getNodeName().equals("ObjectReference");
    }

    private boolean isNullObject() {
        return this.getCurrentElement().getNodeName().equals("NullObject");
    }

    private boolean isPrimitive() {
        return this.getCurrentElement().getNodeName().equals("Primitive");
    }

    private boolean isArray() {
        return this.getCurrentElement().getNodeName().equals("Array");
    }

    private boolean isCollection() {
        return this.getCurrentElement().getNodeName().equals("Collection");
    }

    private boolean isMap() {
        return this.getCurrentElement().getNodeName().equals("Map");
    }

    private boolean isObject() {
        return !this.isArray() && !this.isNullObject() && !this.isPrimitive() && !this.isReference();
    }

    private boolean hasNoName(Element child) {
        return this.getNameAttributeValue(child) == null;
    }

    private String getClassAttributeValue(Element element) {
        if (element.hasAttribute("_class")) {
            return element.getAttribute("_class");
        }
        return null;
    }

    private String getNameAttributeValue(Element child) {
        if (child.hasAttribute("_name")) {
            return child.getAttribute("_name");
        }
        return null;
    }

    private boolean isReference(Element child) {
        return child.getNodeName().equals("ObjectReference");
    }

    private boolean isArray(Element child) {
        return child.getNodeName().equals("Array");
    }

    private boolean isPrimitive(Element child) {
        return child.getNodeName().equals("Primitive");
    }

    private boolean isString(Element child) {
        if (child.getNodeName().equals("Primitive")) {
            String string = this.getClassAttributeValue(child);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.getName())) {
                return true;
            }
        }
        return false;
    }

    private boolean isNullObject(Element child) {
        return child.getNodeName().equals("NullObject");
    }

    private boolean isAttribute(Attr attribute) {
        return !attribute.getName().equals("_class") && !attribute.getName().equals("_id") && !attribute.getName().equals("idref") && !attribute.getName().equals("size") && !attribute.getName().equals("value") && !attribute.getName().equals("_name");
    }

    private List getChildElements(Element element) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                elements.add(node);
            }
            ++i;
        }
        return elements;
    }

    private Element getFirstChildElement(Element element) {
        Node child = element.getFirstChild();
        while (!(child instanceof Element)) {
            child = child.getNextSibling();
        }
        return (Element)child;
    }

    private Element getNextSibilingElement(Element element) {
        Node sibiling = element.getNextSibling();
        while (sibiling != null) {
            if (sibiling instanceof Element) {
                return (Element)sibiling;
            }
            sibiling = sibiling.getNextSibling();
        }
        return null;
    }

    private String readPrimitiveValueAsString() {
        this.startReadChildElement();
        Element child = this.getCurrentElement();
        String value = null;
        if (child.hasAttribute("value")) {
            value = child.getAttribute("value");
        }
        this.finishReadElement();
        return value;
    }

    public boolean readBoolean() throws IOException {
        String value = this.readPrimitiveValueAsString();
        return Boolean.getBoolean(value);
    }

    public byte readByte() throws IOException {
        String value = this.readPrimitiveValueAsString();
        return Byte.parseByte(value);
    }

    public char readChar() throws IOException {
        String value = this.readPrimitiveValueAsString();
        if (value.length() != 1) {
            throw new IllegalStateException("Invalid char value" + value);
        }
        return value.charAt(0);
    }

    public double readDouble() throws IOException {
        String value = this.readPrimitiveValueAsString();
        return Double.parseDouble(value);
    }

    public float readFloat() throws IOException {
        String value = this.readPrimitiveValueAsString();
        return Float.parseFloat(value);
    }

    public int readInt() throws IOException {
        String value = this.readPrimitiveValueAsString();
        return Integer.parseInt(value);
    }

    public long readLong() throws IOException {
        String value = this.readPrimitiveValueAsString();
        return Long.parseLong(value);
    }

    public short readShort() throws IOException {
        String value = this.readPrimitiveValueAsString();
        return Short.parseShort(value);
    }

    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFully(byte[] buf) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public int readUnsignedByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int readUnsignedShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        throw new UnsupportedOperationException();
    }

    public int skipBytes(int len) throws IOException {
        throw new UnsupportedOperationException();
    }
}

