/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.refrection;

import java.util.Map;
import java.util.WeakHashMap;
import jp.ac.keio.sfc.crew.refrection.ArrayObject;
import jp.ac.keio.sfc.crew.refrection.ClassObject;
import jp.ac.keio.sfc.crew.refrection.NullObject;
import jp.ac.keio.sfc.crew.refrection.ObjectObject;
import jp.ac.keio.sfc.crew.refrection.PrimitiveObject;

public abstract class WrapperObject {
    private static Map allInstances = new WeakHashMap();

    public static WrapperObject getInstance(Object object) {
        if (object == null) {
            return NullObject.INSTANCE;
        }
        return WrapperObject.getInstance(object, object.getClass());
    }

    public static WrapperObject getInstance(Object object, Class type) {
        if (object == null) {
            return NullObject.INSTANCE;
        }
        if (object instanceof WrapperObject) {
            return (WrapperObject)object;
        }
        if (allInstances.containsKey(object)) {
            return (WrapperObject)allInstances.get(object);
        }
        if (ClassObject.lookup(type).isPrimitive()) {
            return PrimitiveObject.createObject(type, object);
        }
        if (ClassObject.lookup(type).isArray()) {
            return WrapperObject.createArrayObject(object);
        }
        return WrapperObject.createObjectObject(object);
    }

    private static ArrayObject createArrayObject(Object object) {
        ArrayObject wrapper = ArrayObject.createObject(object);
        allInstances.put(object, wrapper);
        return wrapper;
    }

    private static ObjectObject createObjectObject(Object object) {
        ObjectObject wrapper = new ObjectObject(object, 136);
        allInstances.put(object, wrapper);
        return wrapper;
    }

    public abstract Class getType();

    public abstract Object getValue();
}

