/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.jface.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.ac.keio.sfc.crew.swing.jface.list.ListListModel;

public class ListPanel
extends JPanel {
    private ListListModel model = null;
    private JList jList = new JList();

    public ListPanel() {
        this(new ArrayList());
    }

    public ListPanel(List list) {
        this.model = new ListListModel(list);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane();
        this.jList.setModel(this.model);
        scroll.getViewport().add(this.jList);
        this.add((Component)scroll, "Center");
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = Math.max(size.width, 50);
        size.height = Math.max(size.height, 50);
        return size;
    }

    public void refresh() {
        this.model.update();
        this.initializeSelection();
    }

    private void initializeSelection() {
        this.jList.setSelectedIndices(new int[0]);
    }

    public List getList() {
        return new ArrayList(this.model.getList());
    }

    public void addElements(List elements) {
        this.model.getList().addAll(elements);
        this.initializeSelection();
    }

    public void setList(List list) {
        this.model.setList(list);
        this.initializeSelection();
    }

    public JList getJList() {
        return this.jList;
    }

    public ListListModel getModel() {
        return this.model;
    }

    public List getSelectedElements() {
        return Arrays.asList(this.jList.getSelectedValues());
    }

    public Object getSelectedElement() {
        return this.jList.getSelectedValue();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 300);
        ListPanel listPanel = new ListPanel();
        frame.getContentPane().add(listPanel);
        frame.show();
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u3042");
        list.add("\u3044");
        list.add("\u3046");
        listPanel.setList(list);
        list.add("\u3048");
        listPanel.refresh();
    }
}

