/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

public class LightWeightLayerVisualComponent
extends LayerVisualComponent {
    private List components = new ArrayList();
    private BufferedImage cash = null;

    protected void addImpl(Component comp, Object constraints, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (index == -1) {
                this.components.add(comp);
            } else {
                this.components.add(index, comp);
            }
            if (comp instanceof VisualComponent) {
                VisualComponent visual = (VisualComponent)comp;
                if (visual.getParentVisual() != null) {
                    visual.getParentVisual().remove(comp);
                }
                visual.setParentVisual(this);
            }
            this.repaint();
        }
    }

    public void remove(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.components.remove(index);
            this.repaint();
        }
    }

    public void remove(Component comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.components.remove(comp);
            this.repaint();
        }
    }

    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.components.clear();
            this.repaint();
        }
    }

    protected void paintVisual(Graphics2D g) {
        int size = this.components.size();
        int i = 0;
        while (i < size) {
            Component component = (Component)this.components.get(i);
            if (component.isVisible() && component instanceof VisualComponent) {
                ((VisualComponent)component).paintVisual(g);
            }
            ++i;
        }
    }
}

