/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

public class RectangleVisualComponent
extends VisualComponent {
    private BasicStroke stroke = new BasicStroke(1.0f);

    public void setLineWidth(float width) {
        this.stroke = new BasicStroke(width);
    }

    protected void paintVisual(Graphics2D g) {
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.getBackground() != null) {
            g.setColor(this.getBackground());
            g.fillRect(x, y, w, h);
        }
        int lw = (int)this.stroke.getLineWidth();
        int dx = x + lw / 2;
        int dy = y + lw / 2;
        int dw = w - lw - 1;
        int dh = h - lw - 1;
        if (this.getForeground() != null) {
            g.setStroke(this.stroke);
            g.setColor(this.getForeground());
            g.drawRect(dx, dy, dw, dh);
        }
    }
}

