/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import jp.ac.keio.sfc.crew.swing.SwingUtil;
import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.LightWeightLayerVisualComponent;

public class VisualComponent
extends JComponent {
    private VisualComponent parentVisual;

    public VisualComponent() {
        this.setLayout(null);
        this.setOpaque(false);
        this.setForeground(SwingUtil.COLOR_OPAQUE);
        this.setBackground(SwingUtil.COLOR_OPAQUE);
    }

    public void translateToAbsolute(Point point) {
        if (this instanceof LayerVisualComponent) {
            return;
        }
        Container current = this.getParent();
        while (current != null && !(current instanceof LayerVisualComponent)) {
            point.translate(current.getX(), current.getY());
            current = current.getParent();
        }
    }

    public Point getCenterLocation() {
        Rectangle bounds = this.getBounds();
        return new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
    }

    public Point getAbsoluteLocation() {
        Point location = this.getLocation();
        this.translateToAbsolute(location);
        return location;
    }

    public Point getAbsoluteCenterLocation() {
        Point location = this.getCenterLocation();
        this.translateToAbsolute(location);
        return location;
    }

    public void moveLocation(int mx, int my) {
        Point location = this.getLocation();
        location.x += mx;
        location.y += my;
        this.setLocation(location);
    }

    public void setLocationByCenter(Point location) {
        this.setLocationByCenter(location.x, location.y);
    }

    public void setLocationByCenter(int cx, int cy) {
        int x = cx - this.getWidth() / 2;
        int y = cy - this.getHeight() / 2;
        this.setLocation(x, y);
    }

    public void setSizeToPreffered() {
        this.setSize(this.getPreferredSize());
    }

    public void repaint() {
        if (this.getParentVisual() != null && this.getParentVisual() instanceof LightWeightLayerVisualComponent) {
            this.getParentVisual().repaint();
        } else {
            super.repaint();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getParentVisual() != null && this.getParentVisual() instanceof LightWeightLayerVisualComponent) {
            this.getParentVisual().repaint();
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.paintVisual((Graphics2D)g);
    }

    protected void paintVisual(Graphics2D g) {
    }

    public VisualComponent getParentVisual() {
        return this.parentVisual;
    }

    public void setParentVisual(VisualComponent component) {
        this.parentVisual = component;
    }
}

