/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.thread;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ac.keio.sfc.crew.thread.CThreadEvent;
import jp.ac.keio.sfc.crew.thread.CThreadListener;

public abstract class CThread
implements Runnable {
    public static final int STARTING = 1;
    public static final int RUNNING = 2;
    public static final int STOPPING = 3;
    public static final int STOPPED = 4;
    private Thread thread;
    private Object waitLock = new Object();
    private Object startLock = new Object();
    private Object threadLock = new Object();
    private int interval = 1000;
    private int state = 4;
    private List listeners = new ArrayList();

    public boolean start() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.getState() == 4) {
                this.startInternal();
                return true;
            }
            return false;
        }
    }

    private void startInternal() {
        this.setState(1);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public boolean startAndWait() {
        try {
            Object object = this.waitLock;
            synchronized (object) {
                if (this.start()) {
                    this.waitLock.wait();
                    return true;
                }
                return false;
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted while thread waiting", ex);
        }
    }

    public boolean stop() {
        try {
            Object object = this.startLock;
            synchronized (object) {
                if (this.getState() == 1) {
                    this.startLock.wait();
                }
            }
            object = this.threadLock;
            synchronized (object) {
                if (this.getState() == 2) {
                    this.setState(3);
                    this.threadLock.notify();
                    return true;
                }
                return false;
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted while thread waiting", ex);
        }
    }

    public boolean stopAndWait() {
        try {
            Object object = this.waitLock;
            synchronized (object) {
                if (this.stop()) {
                    this.waitLock.wait();
                    return true;
                }
                return false;
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted while thread waiting", ex);
        }
    }

    public final void run() {
        Object object = this.threadLock;
        synchronized (object) {
            this.initializeThread();
            this.prepareStart();
            try {
                while (this.getState() == 2) {
                    this.threadLock.wait(this.interval);
                    this.step();
                }
            }
            catch (Throwable ex) {
                this.fireExceptionOccured(ex);
            }
            this.prepareStop();
            this.terminateThread();
        }
    }

    private void initializeThread() {
        Object object = this.startLock;
        synchronized (object) {
            this.setState(2);
            this.startLock.notifyAll();
        }
    }

    private void terminateThread() {
        Object object = this.waitLock;
        synchronized (object) {
            this.thread = null;
            this.setState(4);
            this.waitLock.notifyAll();
        }
    }

    protected abstract void step();

    protected abstract void prepareStart();

    protected abstract void prepareStop();

    public int getState() {
        return this.state;
    }

    protected void setState(int state) {
        if (this.state != state) {
            this.state = state;
            this.fireStateChanged();
        }
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval must set upper zero. interval = " + interval);
        }
        this.interval = interval;
    }

    public synchronized void addThreadListener(CThreadListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeThreadListener(CThreadListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireStateChanged() {
        CThreadEvent event = new CThreadEvent(this, this.getState());
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            CThreadListener listener = (CThreadListener)i.next();
            listener.stateChanged(event);
        }
    }

    protected synchronized void fireExceptionOccured(Throwable ex) {
        CThreadEvent event = new CThreadEvent(this, this.getState(), ex);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            CThreadListener listener = (CThreadListener)i.next();
            listener.exceptionOccured(event);
        }
    }
}

