/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import java.awt.Color;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.animation.AbstractAnimationThread;

public abstract class AbstractBlinkingAnimationThread
extends AbstractAnimationThread {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    private VisualComponent visual;
    private Color bgColor = Color.red;
    private Color fgColor = Color.red;
    private boolean blinkingState = false;
    private int currentStep = 0;
    private Color defaultBgColor;
    private Color defaultFgColor;

    protected void step() {
        if (this.getStepCount() != -1 && this.currentStep >= this.getStepCount() && !this.isLoop()) {
            this.setState(3);
        }
        this.blinkingState = !this.blinkingState;
        this.setColor();
        ++this.currentStep;
    }

    protected void prepareStart() {
        this.currentStep = 0;
        this.blinkingState = true;
        if (this.visual != null) {
            this.defaultFgColor = this.visual.getForeground();
            this.defaultBgColor = this.visual.getBackground();
        }
        this.setColor();
    }

    protected void prepareStop() {
        this.blinkingState = false;
        this.setColor();
    }

    protected abstract void setColor();

    public VisualComponent getVisual() {
        return this.visual;
    }

    public void setVisual(VisualComponent component) {
        this.visual = component;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public void setFgColor(Color color) {
        this.fgColor = color;
    }

    public boolean getBlinkingState() {
        return this.blinkingState;
    }

    public Color getDefaultBgColor() {
        return this.defaultBgColor;
    }

    public Color getDefaultFgColor() {
        return this.defaultFgColor;
    }
}

