/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import java.awt.Color;
import jp.ac.keio.sfc.crew.swing.SwingUtil;
import jp.ac.keio.sfc.crew.swing.visuals.RectangleVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.animation.AbstractBlinkingAnimationThread;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EAnimationEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

public class CoverBlinkingAnimationThread
extends AbstractBlinkingAnimationThread {
    private EGraphicalEditPart parent;
    private RectangleVisualComponent visual = new RectangleVisualComponent();
    private CoverEditPart cover = new CoverEditPart();
    private Color color = SwingUtil.createAlphaedColor(Color.RED, 100);

    protected void prepareStart() {
        if (this.parent != null) {
            this.visual.setVisible(true);
            this.visual.setForeground(SwingUtil.COLOR_OPAQUE);
            this.visual.setBackground(this.color);
            this.parent.addTemporaryAccessories(this.cover);
            this.cover.setEditor(this.parent.getEditor());
            this.cover.setParent(this.parent);
            this.cover.setActive(true);
            this.cover.refreshVisual();
        }
        super.prepareStart();
    }

    protected void prepareStop() {
        super.prepareStop();
        if (this.parent != null) {
            this.cover.setActive(false);
            this.parent.removeTemporaryAccessories(this.cover);
        }
    }

    protected void setColor() {
        if (this.visual != null) {
            Object object = this.visual.getTreeLock();
            synchronized (object) {
                if (!this.getBlinkingState()) {
                    this.visual.setVisible(false);
                } else {
                    this.visual.setVisible(true);
                }
            }
        }
    }

    public EGraphicalEditPart getParent() {
        return this.parent;
    }

    public void setParent(EGraphicalEditPart part) {
        this.parent = part;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    class CoverEditPart
    extends EAnimationEditPart {
        CoverEditPart() {
        }

        protected VisualComponent createVisual() {
            return CoverBlinkingAnimationThread.this.visual;
        }

        public void refreshVisual() {
            VisualComponent parentVisual = this.getParent().getVisual();
            CoverBlinkingAnimationThread.this.visual.setLocation(parentVisual.getAbsoluteLocation());
            CoverBlinkingAnimationThread.this.visual.setSize(parentVisual.getSize());
        }
    }
}

