/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import jp.ac.keio.sfc.crew.view.sgef.animation.Path;

public class LinePath
implements Path {
    private Line2D line;
    private AffineTransform transform;
    private boolean reverse = false;

    public LinePath(Line2D line) {
        this(line, null);
    }

    public LinePath(Line2D line, AffineTransform transform) {
        this.line = line;
        this.transform = transform;
    }

    public Point getPoint(int percentage) {
        if (percentage > 100) {
            percentage = 100;
        }
        if (percentage < 0) {
            percentage = 0;
        }
        double ratio = (double)percentage / 100.0;
        double x1 = this.line.getX1();
        double y1 = this.line.getY1();
        double x2 = this.line.getX2();
        double y2 = this.line.getY2();
        if (this.isReverse()) {
            x1 = this.line.getX2();
            y1 = this.line.getY2();
            x2 = this.line.getX1();
            y2 = this.line.getY1();
        }
        double dx = (x2 - x1) * ratio;
        double dy = (y2 - y1) * ratio;
        Point p = new Point((int)(x1 + dx), (int)(y1 + dy));
        if (this.transform != null) {
            p.translate((int)this.transform.getTranslateX(), (int)this.transform.getTranslateY());
        }
        return p;
    }

    public Line2D getLine() {
        return this.line;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setLine(Line2D line2D) {
        this.line = line2D;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void reverse() {
        this.reverse = !this.reverse;
    }
}

