/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.editparts;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ac.keio.sfc.crew.collection.ListCoordinator;
import jp.ac.keio.sfc.crew.collection.ValueChangeListener;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.SEditor;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPartFactory;

public abstract class SEditPart {
    private SEditor editor;
    private SEditPart parent;
    private Object model = new Object();
    private VisualComponent visual;
    private boolean active = false;
    private ListCoordinator childrenCoordinator = new ListCoordinator(new ChildrenValueChangeListener());
    private Map childrenTable = new LinkedHashMap();

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object object) {
        this.model = object;
    }

    public SEditor getEditor() {
        return this.editor;
    }

    public void setEditor(SEditor editor) {
        this.editor = editor;
    }

    public SEditPart getParent() {
        return this.parent;
    }

    public void setParent(SEditPart part) {
        this.parent = part;
    }

    protected void initialize() {
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.thisSetActive(active);
        this.childrenSetActive(active);
    }

    protected void childrenSetActive(boolean active) {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            SEditPart child = (SEditPart)i.next();
            child.setActive(active);
        }
    }

    protected void thisSetActive(boolean active) {
        if (!this.active && active) {
            this.active = true;
            this.activate();
        } else if (this.active && !active) {
            this.deactivate();
            this.active = false;
        }
    }

    protected void activate() {
        this.refresh();
    }

    protected void deactivate() {
    }

    public void refresh() {
        this.refreshRecursively();
    }

    public void refreshRecursively() {
        this.refreshStructureRecursively();
        this.refreshVisualRecursively();
    }

    public void refreshStructure() {
        this.refreshChildren();
    }

    public void refreshStructureRecursively() {
        this.refreshStructure();
        this.refreshChildrenStructure();
    }

    public void refreshChildrenStructure() {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            SEditPart child = (SEditPart)i.next();
            child.refreshStructureRecursively();
        }
    }

    public VisualComponent getVisual() {
        if (this.visual == null) {
            this.visual = this.createVisual();
        }
        return this.visual;
    }

    protected abstract VisualComponent createVisual();

    protected VisualComponent getContentPane() {
        return this.getVisual();
    }

    public void refreshVisual() {
    }

    public void refreshVisualRecursively() {
        this.refreshVisual();
        this.refreshChildrenVisual();
    }

    protected void refreshChildrenVisual() {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            SEditPart child = (SEditPart)i.next();
            child.refreshVisualRecursively();
        }
    }

    public boolean isSelectable() {
        return false;
    }

    protected SEditPart createOrFindEditPart(Object model) {
        SEditPart editpart = this.getEditor().getEditPart(model);
        if (editpart == null) {
            editpart = this.createEditPart(model);
        }
        return editpart;
    }

    protected SEditPart createEditPart(Object model) {
        SEditPartFactory factory = this.getEditor().getEditPartFactory();
        SEditPart editpart = factory.createEditPart(model);
        editpart.setModel(model);
        this.initializeEditPart(editpart);
        return editpart;
    }

    protected void initializeEditPart(SEditPart editpart) {
        editpart.setEditor(this.getEditor());
        editpart.setParent(this);
        editpart.initialize();
        this.getEditor().registerEditPart(this, editpart);
    }

    protected void terminateEditPart(SEditPart editpart) {
        this.getEditor().unregisterEditPart(this, editpart);
    }

    protected List getModelChildren() {
        return null;
    }

    public List getChildren() {
        return new ArrayList(this.childrenTable.values());
    }

    public void refreshChildren() {
        this.childrenCoordinator.setList(this.getModelChildren());
    }

    protected void addChild(SEditPart editpart, int index) {
        this.childrenTable.put(editpart.getModel(), editpart);
        editpart.setActive(this.isActive());
        this.addChildVisual(editpart, index);
    }

    protected void removeChild(SEditPart editpart) {
        this.removeChildVisual(editpart);
        editpart.setActive(false);
        this.childrenTable.remove(editpart.getModel());
    }

    protected void reorderChild(SEditPart editpart, int index) {
        this.removeChildVisual(editpart);
        this.addChildVisual(editpart, index);
    }

    protected void addChildVisual(SEditPart childEditPart, int index) {
        VisualComponent childVisual = childEditPart.getVisual();
        this.getContentPane().add((Component)childVisual, index);
        this.getContentPane().validate();
    }

    protected void removeChildVisual(SEditPart childEditPart) {
        VisualComponent childVisual = childEditPart.getVisual();
        this.getContentPane().remove(childVisual);
        this.getContentPane().repaint();
    }

    class ChildrenValueChangeListener
    implements ValueChangeListener {
        ChildrenValueChangeListener() {
        }

        public void valueAdded(Object model, int index) {
            SEditPart editpart = SEditPart.this.createOrFindEditPart(model);
            SEditPart.this.addChild(editpart, index);
        }

        public void valueRemoved(Object model) {
            SEditPart editpart = (SEditPart)SEditPart.this.childrenTable.get(model);
            SEditPart.this.removeChild(editpart);
            SEditPart.this.terminateEditPart(editpart);
        }

        public void valueReorderd(Object model, int index) {
            SEditPart editpart = (SEditPart)SEditPart.this.childrenTable.get(model);
            SEditPart.this.reorderChild(editpart, index);
        }
    }
}

