/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.tools;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ac.keio.sfc.crew.swing.SwingUtil;
import jp.ac.keio.sfc.crew.swing.visuals.RectangleVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.tools.SEditingTool;

public class SDragMoveTool
extends SEditingTool
implements MouseListener,
MouseMotionListener {
    private VisualComponent memento;
    private Point previousLocation;
    boolean isDragging = false;
    boolean isMoving = false;

    public SDragMoveTool(SGraphicalEditor editor) {
        super(editor);
    }

    protected void activate() {
        this.getEditor().getRootLayer().addMouseListener(this);
        this.getEditor().getRootLayer().addMouseMotionListener(this);
    }

    protected void deactivate() {
        this.getEditor().getRootLayer().removeMouseListener(this);
        this.getEditor().getRootLayer().removeMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.setPreviousLocation(e.getPoint());
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isDragging()) {
            this.endDrag(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.isDragging()) {
            this.startDrag(e);
        }
        if (this.isMoving()) {
            this.move(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void move(MouseEvent e) {
        int mx = e.getX() - (int)this.previousLocation.getX();
        int my = e.getY() - (int)this.previousLocation.getY();
        this.memento.moveLocation(mx, my);
        this.setPreviousLocation(e.getPoint());
    }

    private void startDrag(MouseEvent e) {
        this.setDragging(true);
        if (this.getEditor().hasSelectedEditPart()) {
            this.startMove();
        }
    }

    private void endDrag(MouseEvent e) {
        this.setDragging(false);
        if (this.isMoving()) {
            this.endMove();
        }
    }

    private void startMove() {
        this.setMoving(true);
        this.setMemento(this.createMemento());
        this.getEditor().getSelectionLayer().add(this.getMemento());
        this.getEditor().getSelectionLayer().validate();
    }

    private void endMove() {
        this.moveCompleted();
        this.getEditor().getSelectionLayer().remove(this.getMemento());
        this.getEditor().getSelectionLayer().repaint();
        this.setMoving(false);
    }

    private void moveCompleted() {
        Object object = this.getEditor().getTreeLock();
        synchronized (object) {
            List editparts = this.getEditor().getSelectedEditParts();
            int size = editparts.size();
            int i = 0;
            while (i < size) {
                SEditPart editpart = (SEditPart)editparts.get(i);
                VisualComponent aMemento = (VisualComponent)this.getMemento().getComponent(i);
                Point location = aMemento.getAbsoluteLocation();
                editpart.getVisual().setLocation(location);
                editpart.refreshVisualRecursively();
                ++i;
            }
            this.getEditor().repaint();
        }
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean b) {
        this.isDragging = b;
    }

    public Point getPreviousLocation() {
        return this.previousLocation;
    }

    public void setPreviousLocation(Point point) {
        this.previousLocation = point;
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public void setMoving(boolean b) {
        this.isMoving = b;
    }

    public VisualComponent getMemento() {
        return this.memento;
    }

    public void setMemento(VisualComponent component) {
        this.memento = component;
    }

    protected VisualComponent createMemento() {
        ArrayList<VisualComponent> mementos = new ArrayList<VisualComponent>();
        List selectedParts = this.getEditor().getSelectedEditParts();
        Rectangle r = null;
        Iterator i = selectedParts.iterator();
        while (i.hasNext()) {
            SEditPart editpart = (SEditPart)i.next();
            VisualComponent visual = editpart.getVisual();
            VisualComponent aMemento = this.createMementoVisual();
            aMemento.setBounds(visual.getBounds());
            mementos.add(aMemento);
            r = r == null ? aMemento.getBounds() : r.union(aMemento.getBounds());
        }
        RectangleVisualComponent memento = new RectangleVisualComponent();
        memento.setBounds(r);
        Iterator i2 = mementos.iterator();
        while (i2.hasNext()) {
            VisualComponent aMemento = (VisualComponent)i2.next();
            aMemento.moveLocation((int)(-r.getX()), (int)(-r.getY()));
            memento.add(aMemento);
        }
        return memento;
    }

    protected VisualComponent createMementoVisual() {
        RectangleVisualComponent memento = new RectangleVisualComponent();
        memento.setForeground(SwingUtil.COLOR_OPAQUE);
        memento.setBackground(SwingUtil.createAlphaedColor(Color.blue, 75));
        return memento;
    }
}

