/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.container;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.container.PluginManager;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.presentation.PresentationContainer;

public class BESPContainer {
    private ModelContainer modelContainer = null;
    private PresentationContainer presentationContainer = null;
    private PluginManager pluginManager = null;

    public void initialize() throws Exception {
        this.getModelContainer().initialize();
        this.getPresentationContainer().initialize();
        this.getPresentationContainer().setInitialStatusMessage(BESP.resource.getString("loadPlugin"));
        this.getPluginManager().loadPlugin();
        this.getPresentationContainer().getMainFrame().show();
    }

    public void terminate() {
        this.getPluginManager().terminatePlugins();
        this.getPresentationContainer().terminate();
        this.getModelContainer().terminate();
    }

    public ModelContainer getModelContainer() {
        if (this.modelContainer == null) {
            this.modelContainer = new ModelContainer(this);
        }
        return this.modelContainer;
    }

    public PresentationContainer getPresentationContainer() {
        if (this.presentationContainer == null) {
            this.presentationContainer = new PresentationContainer(this);
        }
        return this.presentationContainer;
    }

    public PluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = new PluginManager(this);
        }
        return this.pluginManager;
    }
}

